/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;

public class ItemKappaCompass
extends Item {
    public ItemKappaCompass() {
        super(new Item.Properties().stacksTo(1));
    }

    public static void addPoint(Activity activity, BlockPos pos, ItemStack compass) {
        Map activityPos = Objects.requireNonNullElse((Map)compass.get(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS), new HashMap());
        activityPos.put(activity.getName(), pos);
        compass.set(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS, (Object)activityPos);
    }

    public static void addDimension(ResourceLocation dimension, ItemStack compass) {
        compass.set(InitDataComponent.KAPPA_COMPASS_DIMENSION, (Object)dimension.toString());
    }

    @Nullable
    public static BlockPos getPoint(Activity activity, ItemStack compass) {
        Map activityPos = (Map)compass.get(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
        if (activityPos != null) {
            String name = activity.getName();
            if (activityPos.containsKey(name)) {
                return (BlockPos)activityPos.get(name);
            }
            name = Activity.IDLE.getName();
            if (activityPos.containsKey(name)) {
                return (BlockPos)activityPos.get(name);
            }
            name = Activity.WORK.getName();
            if (activityPos.containsKey(name)) {
                return (BlockPos)activityPos.get(name);
            }
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getDimension(ItemStack compass) {
        String dim = (String)compass.get(InitDataComponent.KAPPA_COMPASS_DIMENSION);
        if (dim != null) {
            return ResourceLocation.parse((String)dim);
        }
        return null;
    }

    public static int getRecordCount(ItemStack compass) {
        Map activityPos = (Map)compass.get(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
        if (activityPos != null) {
            return activityPos.size();
        }
        return 0;
    }

    public static boolean hasKappaCompassData(ItemStack compass) {
        return compass.has(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS) && compass.has(InitDataComponent.KAPPA_COMPASS_DIMENSION);
    }

    public InteractionResult interactLivingEntity(ItemStack compass, Player player, LivingEntity livingEntity, InteractionHand hand) {
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            if (!maid.level.isClientSide) {
                if (player.isDiscrete()) {
                    maid.getSchedulePos().clear(maid);
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.maid_clear"));
                    player.level.playSound(null, player.blockPosition(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                ResourceLocation dimension = ItemKappaCompass.getDimension(compass);
                if (compass.has(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS) || dimension != null) {
                    if (!maid.level.dimension().location().equals((Object)dimension)) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.maid_dimension_check"));
                        return InteractionResult.CONSUME;
                    }
                    maid.getSchedulePos().setDimension(dimension);
                    BlockPos point = ItemKappaCompass.getPoint(Activity.WORK, compass);
                    if (point != null) {
                        maid.getSchedulePos().setWorkPos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(Activity.IDLE, compass)) != null) {
                        maid.getSchedulePos().setIdlePos(point);
                    }
                    if ((point = ItemKappaCompass.getPoint(Activity.REST, compass)) != null) {
                        maid.getSchedulePos().setSleepPos(point);
                    }
                    maid.getSchedulePos().setConfigured(true);
                    maid.getSchedulePos().restrictTo(maid);
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.maid_write"));
                    player.level.playSound(null, player.blockPosition(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.no_data"));
                return InteractionResult.CONSUME;
            }
        }
        return super.interactLivingEntity(compass, player, livingEntity, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        ItemStack compass = context.getItemInHand();
        BlockPos clickedPos = context.getClickedPos();
        if (player == null) {
            return super.useOn(context);
        }
        if (player.isDiscrete()) {
            compass.remove(InitDataComponent.KAPPA_COMPASS_ACTIVITY_POS);
            compass.remove(InitDataComponent.KAPPA_COMPASS_DIMENSION);
            this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.clear"));
        } else {
            int recordCount = ItemKappaCompass.getRecordCount(compass);
            if (recordCount >= 3) {
                this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.full"));
            } else if (recordCount == 2) {
                BlockPos idlePos = ItemKappaCompass.getPoint(Activity.IDLE, compass);
                if (idlePos != null && idlePos.distSqr((Vec3i)clickedPos) > 4096.0) {
                    this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.useOn(context);
                }
                ItemKappaCompass.addPoint(Activity.REST, clickedPos, compass);
                this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()}));
            } else if (recordCount == 1) {
                BlockPos workPos = ItemKappaCompass.getPoint(Activity.WORK, compass);
                if (workPos != null && workPos.distSqr((Vec3i)clickedPos) > 4096.0) {
                    this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.far_away"));
                    return super.useOn(context);
                }
                ItemKappaCompass.addPoint(Activity.IDLE, clickedPos, compass);
                this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()}));
            } else {
                ItemKappaCompass.addPoint(Activity.WORK, clickedPos, compass);
                this.sendMessage(player, (Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{clickedPos.getX(), clickedPos.getY(), clickedPos.getZ()}));
            }
            ItemKappaCompass.addDimension(player.level.dimension().location(), compass);
        }
        player.level.playSound(null, player.blockPosition(), (SoundEvent)InitSounds.COMPASS_POINT.get(), SoundSource.PLAYERS, 0.8f, 1.5f);
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> components, TooltipFlag flagIn) {
        if (ItemKappaCompass.hasKappaCompassData(stack)) {
            ResourceLocation dimension = ItemKappaCompass.getDimension(stack);
            BlockPos workPos = ItemKappaCompass.getPoint(Activity.WORK, stack);
            BlockPos idlePos = ItemKappaCompass.getPoint(Activity.IDLE, stack);
            BlockPos sleepPos = ItemKappaCompass.getPoint(Activity.REST, stack);
            if (dimension != null) {
                components.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{dimension.toString()}).withStyle(ChatFormatting.GOLD));
            }
            if (workPos != null) {
                components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.work", (Object[])new Object[]{workPos.getX(), workPos.getY(), workPos.getZ()}).withStyle(ChatFormatting.RED));
            }
            if (idlePos != null) {
                components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.idle", (Object[])new Object[]{idlePos.getX(), idlePos.getY(), idlePos.getZ()}).withStyle(ChatFormatting.GREEN));
            }
            if (sleepPos != null) {
                components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.sleep", (Object[])new Object[]{sleepPos.getX(), sleepPos.getY(), sleepPos.getZ()}).withStyle(ChatFormatting.BLUE));
            }
            components.add((Component)Component.empty());
        }
        components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.usage.set_pos"));
        components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.usage.clear_pos"));
        components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.usage.write_pos_to_maid"));
        components.add((Component)Component.translatable((String)"message.touhou_little_maid.kappa_compass.usage.clear_maid_pos"));
    }

    private void sendMessage(Player player, Component component) {
        if (!player.level.isClientSide) {
            player.sendSystemMessage(component);
        }
    }
}

