/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.DrownProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ExplosionProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ExtraLifeBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.FallProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.FireProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ItemMagnetBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.MagicProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.MuteBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.NimbleFabricBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.ProjectileProtectBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.UndyingTotemBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.WirelessIOBauble;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class BaubleManager {
    private static Map<DeferredHolder<Item, Item>, IMaidBauble> BAUBLES;

    private BaubleManager() {
        BAUBLES = Maps.newHashMap();
    }

    public static void init() {
        BaubleManager manager = new BaubleManager();
        manager.bind((DeferredHolder<Item, Item>)InitItems.DROWN_PROTECT_BAUBLE, (IMaidBauble)new DrownProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.EXPLOSION_PROTECT_BAUBLE, (IMaidBauble)new ExplosionProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.ULTRAMARINE_ORB_ELIXIR, (IMaidBauble)new ExtraLifeBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.FALL_PROTECT_BAUBLE, (IMaidBauble)new FallProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.FIRE_PROTECT_BAUBLE, (IMaidBauble)new FireProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.ITEM_MAGNET_BAUBLE, (IMaidBauble)new ItemMagnetBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.MAGIC_PROTECT_BAUBLE, (IMaidBauble)new MagicProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.NIMBLE_FABRIC, (IMaidBauble)new NimbleFabricBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.PROJECTILE_PROTECT_BAUBLE, (IMaidBauble)new ProjectileProtectBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.MUTE_BAUBLE, (IMaidBauble)new MuteBauble());
        manager.bind(Items.TOTEM_OF_UNDYING, (IMaidBauble)new UndyingTotemBauble());
        manager.bind((DeferredHolder<Item, Item>)InitItems.WIRELESS_IO, (IMaidBauble)new WirelessIOBauble());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.bindMaidBauble(manager);
        }
        BAUBLES = ImmutableMap.copyOf(BAUBLES);
    }

    @Nullable
    public static IMaidBauble getBauble(DeferredHolder<Item, Item> item) {
        return BAUBLES.get(item);
    }

    @Nullable
    public static IMaidBauble getBauble(ItemStack stack) {
        Item item = stack.getItem();
        return BaubleManager.getBauble((DeferredHolder<Item, Item>)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item)));
    }

    public void bind(DeferredHolder<Item, Item> item, IMaidBauble bauble) {
        BAUBLES.put(item, bauble);
    }

    public void bind(Item item, IMaidBauble bauble) {
        BAUBLES.put((DeferredHolder<Item, Item>)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item)), bauble);
    }
}

