/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;

public class FireProtectBauble
implements IMaidBauble {
    public FireProtectBauble() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(MaidDamageEvent event) {
        int slot;
        EntityMaid maid = event.getMaid();
        DamageSource source = event.getSource();
        if (source.is(DamageTypeTags.IS_FIRE) && (slot = ItemsUtil.getBaubleSlotInMaid(maid, this)) >= 0) {
            LivingEntity livingEntity;
            event.setCanceled(true);
            ItemStack stack = maid.getMaidBauble().getStackInSlot(slot);
            maid.hurtAndBreak(stack, 1);
            maid.getMaidBauble().setStackInSlot(slot, stack);
            maid.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300));
            if (!maid.level.isClientSide) {
                maid.level.addFreshEntity((Entity)new EntityExtinguishingAgent(maid.level, maid.position()));
            }
            if ((livingEntity = maid.getOwner()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_protect_bauble");
            }
        }
    }
}

