/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemMagnetBauble
implements IMaidBauble {
    private static final int DELAY = 60;
    private static final int RANGE = 6;

    @Override
    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.tickCount % 60 == 0) {
            this.handlePickup(maid);
        }
    }

    private void handlePickup(EntityMaid maid) {
        Level world = maid.level();
        if (maid.isPickup() && maid.isTame()) {
            List entities = world.getEntities((Entity)maid, maid.getBoundingBox().inflate(6.0), maid::canPickup);
            if (!entities.isEmpty() && maid.isAlive()) {
                for (Entity entityPickup : entities) {
                    if (entityPickup instanceof ItemEntity) {
                        maid.pickupItem((ItemEntity)entityPickup, false);
                    }
                    if (entityPickup instanceof ExperienceOrb) {
                        maid.pickupXPOrb((ExperienceOrb)entityPickup);
                    }
                    if (entityPickup instanceof EntityPowerPoint) {
                        maid.pickupPowerPoint((EntityPowerPoint)entityPickup);
                    }
                    if (!(entityPickup instanceof AbstractArrow)) continue;
                    maid.pickupArrow((AbstractArrow)entityPickup, false);
                }
                LivingEntity livingEntity = maid.getOwner();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_item_magnet_bauble");
                }
            }
        }
    }
}

