/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class WirelessIOBauble
implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static ItemStack insertItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        int i;
        if (stack.isEmpty()) {
            return stack;
        }
        if (!stack.isStackable()) {
            return WirelessIOBauble.insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; i < sizeInventory; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if ((slotConfig == null || i >= slotConfig.size() || !slotConfig.get(i).booleanValue()) && ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)stack) && !slot.isEmpty() && slot.isStackable() && (stack = inventory.insertItem(i, stack, simulate)).isEmpty()) break;
        }
        if (!stack.isEmpty()) {
            for (i = 0; i < sizeInventory && (slotConfig != null && i < slotConfig.size() && slotConfig.get(i).booleanValue() || !inventory.getStackInSlot(i).isEmpty() || !(stack = inventory.insertItem(i, stack, simulate)).isEmpty()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, @Nullable List<Boolean> slotConfig) {
        if (stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (slotConfig != null && i < slotConfig.size() && slotConfig.get(i).booleanValue() || !(stack = dest.insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    @Override
    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.tickCount % 100 == 0 && !maid.guiOpening) {
            BlockPos bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.getRestrictRadius();
            if (maid.distanceToSqr(bindingPos.getX(), bindingPos.getY(), bindingPos.getZ()) > (double)(maxDistance * maxDistance)) {
                return;
            }
            BlockEntity te = maid.level.getBlockEntity(bindingPos);
            if (te == null) {
                return;
            }
            for (IChestType type : ChestManager.getAllChestTypes()) {
                LivingEntity livingEntity;
                if (!type.isChest(te)) continue;
                int openCount = type.getOpenCount((BlockGetter)maid.level, bindingPos, te);
                if (openCount > 0) {
                    return;
                }
                IItemHandler chestInv = (IItemHandler)maid.level.getCapability(Capabilities.ItemHandler.BLOCK, te.getBlockPos(), null);
                if (chestInv != null) {
                    ArrayList<Boolean> slotConfigData;
                    CombinedInvWrapper maidInv = maid.getAvailableInv(false);
                    boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                    boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                    List<Boolean> slotConfig = ItemWirelessIO.getSlotConfig(baubleItem);
                    if (slotConfig != null) {
                        slotConfigData = new ArrayList<Boolean>(slotConfig);
                        slotConfigData.set(maidInv.getSlots() - 2, slotConfig.get(36));
                        slotConfigData.set(maidInv.getSlots() - 1, slotConfig.get(37));
                    } else {
                        slotConfigData = new ArrayList<Boolean>(Collections.nCopies(38, false));
                    }
                    ItemStackHandler filterList = ItemWirelessIO.getFilterList((HolderLookup.Provider)maid.registryAccess(), baubleItem);
                    if (isMaidToChest) {
                        this.maidToChest((IItemHandler)maidInv, chestInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                    } else {
                        this.chestToMaid(chestInv, (IItemHandler)maidInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                    }
                }
                if ((livingEntity = maid.getOwner()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_wireless_io");
                }
                return;
            }
        }
    }

    private void maidToChest(IItemHandler maid, IItemHandler chest, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (int i = 0; i < maid.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            if (i < slotConfig.size() && slotConfig.get(i).booleanValue()) continue;
            ItemStack maidInvItem = maid.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = ItemStack.isSameItem((ItemStack)maidInvItem, (ItemStack)filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = maidInvItem.getCount()) == (afterCount = (after = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)maidInvItem.copy(), (boolean)false)).getCount())) continue;
            maid.extractItem(i, beforeCount - afterCount, false);
        }
    }

    private void chestToMaid(IItemHandler chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, List<Boolean> slotConfig) {
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            ItemStack chestInvStack = chest.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = ItemStack.isSameItem((ItemStack)chestInvStack, (ItemStack)filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = chestInvStack.getCount()) == (afterCount = (after = WirelessIOBauble.insertItemStacked(maid, chestInvStack.copy(), false, slotConfig)).getCount())) continue;
            chest.extractItem(i, beforeCount - afterCount, false);
        }
    }
}

