/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.init.InitLootCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record LootTableTypeCondition(String prefix) implements LootItemCondition
{
    public static final MapCodec<LootTableTypeCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.fieldOf("loot_table_type").forGetter(LootTableTypeCondition::prefix)).apply((Applicative)inst, LootTableTypeCondition::new));

    public boolean test(LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        return lootTableId.getPath().startsWith(this.prefix) && !lootTableId.getNamespace().equals("touhou_little_maid");
    }

    public LootItemConditionType getType() {
        return InitLootCondition.LOOT_TABLE_TYPE.get();
    }
}

