/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public class MixinCrossbowItem {
    @Inject(method={"shootProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/projectile/Projectile;IFFFLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, LivingEntity target, CallbackInfo ci) {
        if (shooter instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)shooter;
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                AttributeInstance attackDamage = maid.getAttribute(Attributes.ATTACK_DAMAGE);
                double attackValue = 2.0;
                if (attackDamage != null) {
                    attackValue = attackDamage.getBaseValue();
                }
                float multiplier = (float)(attackValue / 2.0);
                arrow.setBaseDamage(arrow.getBaseDamage() * (double)multiplier);
            }
            this.shootCrossbowProjectile(shooter, target, projectile, 1.6f);
            ci.cancel();
        }
    }

    @Unique
    private void shootCrossbowProjectile(LivingEntity shooter, LivingEntity target, Projectile projectile, float velocityIn) {
        double x = target.getX() - shooter.getX();
        double y = target.getEyeY() - shooter.getEyeY();
        double z = target.getZ() - shooter.getZ();
        float distance = shooter.distanceTo((Entity)target);
        float velocity = Mth.clamp((float)(distance / 10.0f), (float)velocityIn, (float)3.2f);
        float inaccuracy = 1.0f - Mth.clamp((float)(distance / 100.0f), (float)0.0f, (float)0.9f);
        projectile.setNoGravity(true);
        projectile.shoot(x, y, z, velocity, inaccuracy);
        shooter.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
    }
}

