/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.AssignableVariableExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.DoubleExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.StringExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.VariableExpression;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.AssignableVariable;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.Variable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class IdentifierExpression
implements Expression {
    private final String name;
    private final Object target;

    private IdentifierExpression(@NotNull String name, Object target) {
        Objects.requireNonNull(name, "name");
        this.name = name.toLowerCase();
        this.target = target;
    }

    public static Expression get(String name, Object target) {
        if (target instanceof Number) {
            return new DoubleExpression(((Number)target).doubleValue());
        }
        if (target instanceof String) {
            return new StringExpression((String)target);
        }
        if (target instanceof AssignableVariable) {
            return new AssignableVariableExpression((AssignableVariable)target);
        }
        if (target instanceof Variable) {
            return new VariableExpression((Variable)target);
        }
        return new IdentifierExpression(name, target);
    }

    @NotNull
    public String name() {
        return this.name;
    }

    public Object target() {
        return this.target;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitIdentifier(this);
    }

    public String toString() {
        return "Identifier(" + this.name + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierExpression that = (IdentifierExpression)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

