/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.FoxScrollScreen;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record FoxScrollPackage(Map<String, List<FoxScrollData>> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FoxScrollPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("fox_scroll"));
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FoxScrollData>> LIST_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, FoxScrollData.FOX_SCROLL_DATA_STREAM_CODEC, (int)1024);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<String, List<FoxScrollData>>> BYTE_BUF_MAP_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, LIST_STREAM_CODEC, (int)1024);
    public static final StreamCodec<RegistryFriendlyByteBuf, FoxScrollPackage> STREAM_CODEC = StreamCodec.composite(BYTE_BUF_MAP_STREAM_CODEC, FoxScrollPackage::data, FoxScrollPackage::new);

    public static void handle(FoxScrollPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> FoxScrollPackage.onHandle(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(FoxScrollPackage message) {
        Minecraft.getInstance().setScreen((Screen)new FoxScrollScreen(message.data));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record FoxScrollData(BlockPos pos, Component name, long timestamp) {
        public static final StreamCodec<RegistryFriendlyByteBuf, FoxScrollData> FOX_SCROLL_DATA_STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FoxScrollData::pos, (StreamCodec)ComponentSerialization.STREAM_CODEC, FoxScrollData::name, (StreamCodec)ByteBufCodecs.VAR_LONG, FoxScrollData::timestamp, FoxScrollData::new);
    }
}

