/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidAIDataScreenPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record GetMaidAIDataPackage(int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GetMaidAIDataPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("get_maid_ai_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GetMaidAIDataPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, GetMaidAIDataPackage::entityId, GetMaidAIDataPackage::new);

    public static void handle(GetMaidAIDataPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> GetMaidAIDataPackage.handleInner(message, context));
        }
    }

    private static void handleInner(GetMaidAIDataPackage message, IPayloadContext context) {
        EntityMaid maid;
        ServerPlayer sender = (ServerPlayer)context.player();
        Entity entity = sender.level.getEntity(message.entityId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
            PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new OpenMaidAIDataScreenPackage(message.entityId, maid.getAiChatManager()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

