/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckSchedulePosPacket;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MaidConfigPackage(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MaidConfigPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("maid_config"));
    public static final StreamCodec<ByteBuf, MaidConfigPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, MaidConfigPackage::id, (StreamCodec)ByteBufCodecs.BOOL, MaidConfigPackage::home, (StreamCodec)ByteBufCodecs.BOOL, MaidConfigPackage::pick, (StreamCodec)ByteBufCodecs.BOOL, MaidConfigPackage::ride, MaidSchedule.STREAM_CODEC, MaidConfigPackage::schedule, MaidConfigPackage::new);

    public static void handle(MaidConfigPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.id);
                if (entity instanceof EntityMaid) {
                    EntityMaid maid = (EntityMaid)entity;
                    if (((EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                        if (maid.isHomeModeEnable() != message.home) {
                            MaidConfigPackage.handleHome(message, sender, maid);
                        }
                        if (maid.isPickup() != message.pick) {
                            maid.setPickup(message.pick);
                        }
                        if (maid.isRideable() != message.ride) {
                            maid.setRideable(message.ride);
                        }
                        if (maid.getVehicle() != null && !(maid.getVehicle() instanceof EntitySit)) {
                            maid.stopRiding();
                        }
                        if (maid.getSchedule() != message.schedule) {
                            LivingEntity patt0$temp;
                            maid.setSchedule(message.schedule);
                            maid.getSchedulePos().restrictTo(maid);
                            if (maid.isHomeModeEnable()) {
                                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)maid.getRestrictCenter(), (float)0.7f, (int)3);
                            }
                            if ((patt0$temp = maid.getOwner()) instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                                ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(serverPlayer, "switch_schedule");
                            }
                        }
                    }
                }
            });
        }
    }

    private static void handleHome(MaidConfigPackage message, ServerPlayer sender, EntityMaid maid) {
        if (message.home) {
            ResourceLocation dimension = maid.getSchedulePos().getDimension();
            if (!dimension.equals((Object)maid.level.dimension().location())) {
                CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.dimension");
                PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)tips, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            BlockPos nearestPos = maid.getSchedulePos().getNearestPos(maid);
            if (nearestPos != null && nearestPos.distSqr((Vec3i)maid.blockPosition()) > 1024.0) {
                CheckSchedulePosPacket tips = new CheckSchedulePosPacket("message.touhou_little_maid.check_schedule_pos.too_far");
                PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)tips, (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            maid.getSchedulePos().setHomeModeEnable(maid, maid.blockPosition());
        } else {
            maid.restrictTo(BlockPos.ZERO, (Integer)MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(message.home);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

