/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlayMaidSoundPackage(ResourceLocation soundEvent, String id, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayMaidSoundPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("play_maid_sound"));
    public static final StreamCodec<ByteBuf, PlayMaidSoundPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PlayMaidSoundPackage::soundEvent, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayMaidSoundPackage::id, (StreamCodec)ByteBufCodecs.VAR_INT, PlayMaidSoundPackage::entityId, PlayMaidSoundPackage::new);

    public static void handle(PlayMaidSoundPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> PlayMaidSoundPackage.playSound(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playSound(PlayMaidSoundPackage message) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (entity = mc.level.getEntity(message.entityId)) instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            SoundEvent event = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(message.soundEvent);
            if (event != null) {
                mc.getSoundManager().play((SoundInstance)new MaidSoundInstance(event, message.id, maid));
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

