/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.LittleMaidExtension;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public final class AnnotatedInstanceUtil {
    public static List<ILittleMaid> getModExtensions() {
        return AnnotatedInstanceUtil.getInstances(LittleMaidExtension.class, ILittleMaid.class);
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> extensionClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                if (!Objects.equals(data.annotationType(), annotationType)) continue;
                String memberName = data.memberName();
                extensionClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : extensionClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                TouhouLittleMaid.LOGGER.error("Failed to load: {}", (Object)className, (Object)e);
            }
        }
        return instances;
    }
}

