/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ParseI18n {
    private static final String I18N_START_CHAR = "{";
    private static final String I18N_END_CHAR = "}";

    private ParseI18n() {
    }

    public static String getI18nKey(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return strIn.substring(1, strIn.length() - 1);
        }
        return strIn;
    }

    public static MutableComponent parse(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return Component.translatable((String)strIn.substring(1, strIn.length() - 1));
        }
        return Component.literal((String)strIn);
    }

    public static List<Component> parse(List<String> strIn) {
        ArrayList strOut = Lists.newArrayList();
        for (String str : strIn) {
            strOut.add(ParseI18n.parse(str));
        }
        return strOut;
    }

    public static List<Component> keysToTrans(List<String> keys, ChatFormatting ... formatting) {
        ArrayList out = Lists.newArrayList();
        for (String k : keys) {
            out.add(Component.translatable((String)k).withStyle(formatting));
        }
        return out;
    }
}

