/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="noslimes_creepy_events", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG_LOGS = BUILDER.comment("Whether to log debug messages to the console").define("enableDebugLogs", false);
    private static final ForgeConfigSpec.IntValue RANDOM_INTERVAL_MIN = BUILDER.comment("Minimum value for the random interval (in ticks)").defineInRange("randomIntervalMin", 300, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue RANDOM_INTERVAL_MAX = BUILDER.comment("Maximum value for the random interval (in ticks)").defineInRange("randomIntervalMax", 1200, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue RANDOM_CHANCE = BUILDER.comment("The chance for an event to fire each interval (0-100)").defineInRange("randomChance", 75, 0, 100);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_ALLOW_LIST = BUILDER.comment("List of entity resource locations to spawn (e.g. 'minecraft:arrow')").defineListAllowEmpty(List.of("allowedEntities"), () -> List.of("minecraft:arrow", "minecraft:salmon", "minecraft:bat", "minecraft:silverfish"), Config::validateEntityName);
    private static final ForgeConfigSpec.BooleanValue ALLOW_DROP = BUILDER.comment("Whether to allow to drop items or not").define("allowDropItems", true);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> DROP_DISALLOW_LIST = BUILDER.comment("List of dimensions to disallow from dropping items (e.g. 'minecraft:nether')").defineListAllowEmpty(List.of("disallowedDropDimensions"), () -> List.of("minecraft:the_end"), Config::validateDimensionName);
    private static final ForgeConfigSpec.IntValue MIN_DROP_PERCENTAGE = BUILDER.comment("Minimum percentage of inventory that will be dropped").defineInRange("minDropPercentage", 10, 0, 100);
    private static final ForgeConfigSpec.IntValue MAX_DROP_PERCENTAGE = BUILDER.comment("Maximum percentage of inventory that will be dropped").defineInRange("maxDropPercentage", 50, 0, 100);
    private static final ForgeConfigSpec.BooleanValue ALLOW_ENTITY_SPAWNING = BUILDER.comment("Whether to allow entity spawning").define("allowEntitySpawning", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_POTION_EFFECTS = BUILDER.comment("Whether to allow potion effects").define("allowPotionEffects", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_PLAYER_MESSAGES = BUILDER.comment("Whether to allow player messages").define("allowPlayerMessages", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_SPINNING_PLAYER = BUILDER.comment("Whether to allow spinning player").define("allowSpinningPlayer", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_MOB_TALKING = BUILDER.comment("Whether to allow mob talking").define("allowMobTalking", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_SOUND_PLAYING = BUILDER.comment("Whether to allow sound playing").define("allowSoundPlaying", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_INVENTORY_SCRAMBLE = BUILDER.comment("Whether to allow inventory scrambling").define("allowInventoryScramble", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_ANIMALS_HUNTING = BUILDER.comment("Whether to allow animals hunting players").define("allowAnimalsHunting", true);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enableDebugLogs;
    public static int randomIntervalMin;
    public static int randomIntervalMax;
    public static int randomChance;
    public static Set<EntityType<?>> allowedEntities;
    public static boolean allowDroppingItems;
    public static Set<ResourceKey<Level>> disallowedDropDimensions;
    public static int minDropPercentage;
    public static int maxDropPercentage;
    public static boolean allowEntitySpawning;
    public static boolean allowPotionEffects;
    public static boolean allowPlayerMessages;
    public static boolean allowSpinningPlayer;
    public static boolean allowMobTalking;
    public static boolean allowSoundPlaying;
    public static boolean allowInventoryScramble;
    public static boolean allowAnimalsHunting;

    private static boolean validateEntityName(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String name = (String)obj;
        try {
            ResourceLocation res = new ResourceLocation(name);
            return ForgeRegistries.ENTITY_TYPES.containsKey(res);
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.warn("Invalid entity name format in config: {}", (Object)name);
            return false;
        }
    }

    private static boolean validateDimensionName(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String name = (String)obj;
        try {
            new ResourceLocation(name);
            return true;
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.warn("Invalid dimension name format in config: '{}'", (Object)name);
            return false;
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals("noslimes_creepy_events")) {
            return;
        }
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        NoSlimesCreepyEvents.LOGGER.info("Loading config...");
        Config.loadConfigValues();
        NoSlimesCreepyEvents.logInfo("Loaded {} config for mod {}", event.getConfig().getType(), "noslimes_creepy_events");
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (!event.getConfig().getSpec().equals(SPEC)) {
            return;
        }
        Config.loadConfigValues();
        NoSlimesCreepyEvents.logInfo("Reloaded {} config for mod {}", event.getConfig().getType(), "noslimes_creepy_events");
    }

    private static void loadConfigValues() {
        enableDebugLogs = (Boolean)ENABLE_DEBUG_LOGS.get();
        randomIntervalMin = (Integer)RANDOM_INTERVAL_MIN.get();
        randomIntervalMax = (Integer)RANDOM_INTERVAL_MAX.get();
        randomChance = (Integer)RANDOM_CHANCE.get();
        NoSlimesCreepyEvents.logInfo("Loaded Config - Interval: [{}, {}], Chance: {}", randomIntervalMin, randomIntervalMax, randomChance);
        NoSlimesCreepyEvents.logInfo("Debug Logs Enabled: {}", enableDebugLogs);
        allowDroppingItems = (Boolean)ALLOW_DROP.get();
        minDropPercentage = (Integer)MIN_DROP_PERCENTAGE.get();
        maxDropPercentage = (Integer)MAX_DROP_PERCENTAGE.get();
        NoSlimesCreepyEvents.logInfo("Loaded Drop Config - Allow Drops: {}, Drop Percentage Range: [{}%, {}%]", allowDroppingItems, minDropPercentage, maxDropPercentage);
        allowEntitySpawning = (Boolean)ALLOW_ENTITY_SPAWNING.get();
        allowPotionEffects = (Boolean)ALLOW_POTION_EFFECTS.get();
        allowPlayerMessages = (Boolean)ALLOW_PLAYER_MESSAGES.get();
        allowSpinningPlayer = (Boolean)ALLOW_SPINNING_PLAYER.get();
        allowMobTalking = (Boolean)ALLOW_MOB_TALKING.get();
        allowSoundPlaying = (Boolean)ALLOW_SOUND_PLAYING.get();
        allowInventoryScramble = (Boolean)ALLOW_INVENTORY_SCRAMBLE.get();
        allowAnimalsHunting = (Boolean)ALLOW_ANIMALS_HUNTING.get();
        NoSlimesCreepyEvents.logInfo("Loaded Feature Toggles - Spawning: {}, Potion Effects: {}, Player Messages: {}, Spinning: {}, Mob Talking: {}, Sound Playing: {}", allowEntitySpawning, allowPotionEffects, allowPlayerMessages, allowSpinningPlayer, allowMobTalking, allowSoundPlaying);
        try {
            allowedEntities = ((List)ENTITY_ALLOW_LIST.get()).stream().map(idString -> {
                try {
                    return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(idString));
                }
                catch (Exception e) {
                    NoSlimesCreepyEvents.LOGGER.error("Failed to parse entity resource location from config: {}", idString, (Object)e);
                    return null;
                }
            }).filter(type -> type != null && type != EntityType.f_20532_).collect(Collectors.toSet());
            Object[] objectArray = new Object[1];
            objectArray[0] = allowedEntities.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).map(ResourceLocation::toString).collect(Collectors.joining(", "));
            NoSlimesCreepyEvents.logInfo("Loaded Config - Allowed Entities: {}", objectArray);
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.error("Failed to load allowedEntities from config", (Throwable)e);
            allowedEntities = new HashSet();
        }
        try {
            List dimStrings = (List)DROP_DISALLOW_LIST.get();
            disallowedDropDimensions = dimStrings.stream().map(idString -> {
                try {
                    ResourceLocation rl = new ResourceLocation(idString);
                    return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                }
                catch (Exception e) {
                    NoSlimesCreepyEvents.LOGGER.error("Failed to parse dimension resource location from config: {}", idString, (Object)e);
                    return null;
                }
            }).filter(key -> key != null).collect(Collectors.toSet());
            NoSlimesCreepyEvents.logInfo("Loaded Config - Disallowed Drop Dimensions: {}", disallowedDropDimensions.stream().map(ResourceKey::m_135782_).map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.error("Failed to load disallowedDropDimensions from config", (Throwable)e);
            disallowedDropDimensions = new HashSet<ResourceKey<Level>>();
        }
        if (randomIntervalMin >= randomIntervalMax) {
            NoSlimesCreepyEvents.LOGGER.warn("Config validation failed: randomIntervalMin ({}) must be less than randomIntervalMax ({}). Using defaults for now. Check your config file!", (Object)randomIntervalMin, (Object)randomIntervalMax);
            randomIntervalMin = (Integer)RANDOM_INTERVAL_MIN.getDefault();
            randomIntervalMax = (Integer)RANDOM_INTERVAL_MAX.getDefault();
        }
        if (minDropPercentage > maxDropPercentage) {
            NoSlimesCreepyEvents.LOGGER.warn("Config validation failed: minDropPercentage ({}) must be less or equal to maxDropPercentage ({}). Using defaults for now. Check your config file!", (Object)minDropPercentage, (Object)maxDropPercentage);
            minDropPercentage = (Integer)MIN_DROP_PERCENTAGE.getDefault();
            maxDropPercentage = (Integer)MAX_DROP_PERCENTAGE.getDefault();
        }
    }

    public static boolean setRandomInterval(int min, int max) {
        if (min < 0 || max <= 0 || min >= max) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to set invalid interval: [{}, {}]", (Object)min, (Object)max);
            return false;
        }
        RANDOM_INTERVAL_MIN.set((Object)min);
        RANDOM_INTERVAL_MAX.set((Object)max);
        randomIntervalMin = min;
        randomIntervalMax = max;
        NoSlimesCreepyEvents.logInfo("Set interval to [{}, {}]", min, max);
        SPEC.save();
        return true;
    }

    public static boolean setRandomChance(int chance) {
        if ((double)chance < 0.0 || (double)chance > 100.0) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to set invalid chance: {}", (Object)chance);
            return false;
        }
        RANDOM_CHANCE.set((Object)chance);
        randomChance = chance;
        NoSlimesCreepyEvents.logInfo("Set chance to {}", chance);
        SPEC.save();
        return true;
    }

    static {
        allowedEntities = new HashSet();
        disallowedDropDimensions = new HashSet<ResourceKey<Level>>();
    }
}

