/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.noslimes.noslimes_creepy_events.Config;
import com.noslimes.noslimes_creepy_events.EventModules.EntitySpawnerModule;
import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.EventModules.InventoryDropModule;
import com.noslimes.noslimes_creepy_events.EventModules.InventoryScrambleModule;
import com.noslimes.noslimes_creepy_events.EventModules.MobStareModule;
import com.noslimes.noslimes_creepy_events.EventModules.PassiveMobsHuntingModule;
import com.noslimes.noslimes_creepy_events.EventModules.PlayerSpinnerModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomEffectModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomPlayerThreatenModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomSoundPlayerModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomTalkerModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class EventCaller {
    private static final Map<EventModule, Integer> modules;
    private static final int totalWeight;
    private static final Random random;
    private static int ticksRemaining;
    private static final Set<EventModule> disabledModules;
    private static EventModule lastExecutedModule;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new EventCaller());
        NoSlimesCreepyEvents.logInfo("EventCaller registered successfully.", new Object[0]);
    }

    public static void setupModules() {
        EventCaller.disableBasedOnConfig(Config.allowEntitySpawning, EntitySpawnerModule.class);
        EventCaller.disableBasedOnConfig(Config.allowMobTalking, RandomTalkerModule.class);
        EventCaller.disableBasedOnConfig(Config.allowMobTalking, PassiveMobsHuntingModule.class);
        EventCaller.disableBasedOnConfig(Config.allowSoundPlaying, RandomSoundPlayerModule.class);
        EventCaller.disableBasedOnConfig(Config.allowPotionEffects, RandomEffectModule.class);
        EventCaller.disableBasedOnConfig(Config.allowSpinningPlayer, PlayerSpinnerModule.class);
        EventCaller.disableBasedOnConfig(Config.allowDroppingItems, InventoryDropModule.class);
        EventCaller.disableBasedOnConfig(Config.allowPlayerMessages, RandomPlayerThreatenModule.class);
        EventCaller.disableBasedOnConfig(Config.allowInventoryScramble, InventoryScrambleModule.class);
        EventCaller.disableBasedOnConfig(Config.allowAnimalsHunting, MobStareModule.class);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (ticksRemaining > 0) {
            --ticksRemaining;
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null || modules.isEmpty()) {
            NoSlimesCreepyEvents.LOGGER.warn("Server or modules are null/empty. Cannot execute commands.");
            EventCaller.resetInterval();
            return;
        }
        int tries = 0;
        boolean success = false;
        while (tries < 10 && !success) {
            success = this.runRandomModule(server);
            if (success) continue;
            NoSlimesCreepyEvents.logInfo("Retrying... Attempt {} of 10", ++tries);
        }
        if (!success) {
            NoSlimesCreepyEvents.LOGGER.warn("Failed to execute a module after 10 attempts.");
        }
        EventCaller.resetInterval();
    }

    private boolean runRandomModule(MinecraftServer server) {
        EventModule selected = null;
        if (this.executionRoll()) {
            selected = this.selectModuleBasedOnWeight();
            if (selected == null) {
                NoSlimesCreepyEvents.LOGGER.error("No valid module selected. Skipping execution.");
            } else {
                lastExecutedModule = selected;
                return this.runSelectedModule(server, selected);
            }
        }
        return false;
    }

    private boolean runSelectedModule(MinecraftServer server, @NotNull EventModule module) {
        NoSlimesCreepyEvents.logInfo("Selected module: {}", module.getClass().getSimpleName());
        try {
            module.run(server);
            NoSlimesCreepyEvents.logInfo("Executed module: {}", module.getClass().getSimpleName());
            return true;
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.logInfo("Error executing module: {}", module.getClass().getSimpleName(), e);
            return false;
        }
    }

    private static void resetInterval() {
        ticksRemaining = Config.randomIntervalMin + random.nextInt(Config.randomIntervalMax - Config.randomIntervalMin + 1);
        NoSlimesCreepyEvents.logInfo("Next interval set to: {} ticks.", ticksRemaining);
    }

    private EventModule selectModuleBasedOnWeight() {
        int randomWeight = random.nextInt(totalWeight);
        int cumulativeWeight = 0;
        ArrayList<EventModule> availableModules = new ArrayList<EventModule>();
        for (Map.Entry<EventModule, Integer> entry : modules.entrySet()) {
            EventModule module = entry.getKey();
            if (disabledModules.contains(module) || module == lastExecutedModule && !availableModules.isEmpty()) continue;
            availableModules.add(module);
            cumulativeWeight += entry.getValue().intValue();
        }
        if (availableModules.isEmpty()) {
            NoSlimesCreepyEvents.LOGGER.warn("No available modules to select from.");
            return null;
        }
        randomWeight = random.nextInt(cumulativeWeight);
        cumulativeWeight = 0;
        for (EventModule module : availableModules) {
            if (randomWeight >= (cumulativeWeight += modules.get(module).intValue())) continue;
            return module;
        }
        return null;
    }

    private boolean executionRoll() {
        int roll = random.nextInt(100);
        if (roll < Config.randomChance) {
            NoSlimesCreepyEvents.logInfo("Passed chance check: roll ({}) < chance ({}%)", roll, Config.randomChance);
            return true;
        }
        NoSlimesCreepyEvents.logInfo("Skipped execution: roll ({}) >= chance ({}%)", roll, Config.randomChance);
        return false;
    }

    public static void disableModule(EventModule module) {
        disabledModules.add(module);
        NoSlimesCreepyEvents.logInfo("Module {} disabled.", module.getClass().getSimpleName());
    }

    public static void enableModule(EventModule module) {
        disabledModules.remove(module);
        NoSlimesCreepyEvents.logInfo("Module {} enabled.", module.getClass().getSimpleName());
    }

    public static <T extends EventModule> T getModule(Class<T> moduleClass) {
        for (EventModule module : modules.keySet()) {
            if (!module.getClass().equals(moduleClass)) continue;
            return (T)((EventModule)moduleClass.cast(module));
        }
        return null;
    }

    public static void skipInterval() {
        ticksRemaining = 0;
    }

    private static <T extends EventModule> void disableBasedOnConfig(boolean configValue, Class<T> moduleClass) {
        T module = EventCaller.getModule(moduleClass);
        if (module != null) {
            if (configValue) {
                EventCaller.enableModule(module);
            } else {
                EventCaller.disableModule(module);
            }
        } else {
            NoSlimesCreepyEvents.LOGGER.warn("Module class {} not found.", (Object)moduleClass.getSimpleName());
        }
    }

    static {
        random = new Random();
        ticksRemaining = 0;
        disabledModules = new HashSet<EventModule>();
        lastExecutedModule = null;
        HashMap<EventModule, Integer> builder = new HashMap<EventModule, Integer>();
        builder.put(new EntitySpawnerModule(), 6);
        builder.put(new RandomTalkerModule(), 8);
        builder.put(new RandomSoundPlayerModule(), 7);
        builder.put(new RandomEffectModule(), 6);
        builder.put(new PlayerSpinnerModule(), 5);
        builder.put(new InventoryDropModule(), 2);
        builder.put(new RandomPlayerThreatenModule(), 3);
        builder.put(new InventoryScrambleModule(), 4);
        builder.put(new MobStareModule(), 100);
        builder.put(new PassiveMobsHuntingModule(), 100);
        modules = Collections.unmodifiableMap(builder);
        totalWeight = modules.values().stream().mapToInt(Integer::intValue).sum();
    }
}

