/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import com.noslimes.noslimes_creepy_events.util.MobStareHandler;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;

public class MobStareModule
extends EventModule {
    private static final int STARE_DURATION_TICKS = 100;

    @Override
    public boolean run(MinecraftServer server) {
        ServerPlayer targetPlayer = this.getRandomPlayer(server);
        if (targetPlayer == null) {
            return false;
        }
        ServerLevel level = targetPlayer.m_9236_();
        AABB searchArea = new AABB(targetPlayer.m_20183_()).m_82400_(25.0);
        List nearbyMobs = level.m_6443_(Mob.class, searchArea, entity -> !entity.m_213877_());
        for (Mob staringMob : nearbyMobs) {
            level.m_6263_(null, staringMob.m_20185_(), staringMob.m_20186_(), staringMob.m_20189_(), SoundEvents.f_12499_, SoundSource.HOSTILE, 1.0f, 0.7f + this.random.nextFloat() * 0.4f);
            boolean didStart = MobStareHandler.startStare(staringMob, (LivingEntity)targetPlayer, 100);
            if (didStart) {
                NoSlimesCreepyEvents.logInfo("Started stare for mob {} ", staringMob.m_20148_());
                continue;
            }
            NoSlimesCreepyEvents.logInfo("Could not start stare for mob {} (already staring or invalid?).", staringMob.m_20148_());
        }
        return true;
    }
}

