/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;

public class RandomPlayerThreatenModule
extends EventModule {
    private final Random random = new Random();
    private static final double MAX_DISTANCE = 50.0;
    private static final double MAX_DISTANCE_SQ = 2500.0;
    private static final List<String> THREAT_TEMPLATES = List.of("I know where you\u2019re hiding, {TARGET}. Don\u2019t think you\u2019re safe.", "You really think you\u2019re alone, {TARGET}? Think again.", "I\u2019ve been watching you, {TARGET}. Every move, every block.", "You won\u2019t hear it coming, {TARGET}, but I\u2019ll be right behind you.", "The silence is deafening, {TARGET}. You should be worried about that.", "You\u2019ve made a mistake, {TARGET}, and I\u2019ll make sure you regret it.", "I can see you through the fog, {TARGET}. Don\u2019t try to run.", "It\u2019s not the mobs you should fear, {TARGET}. It\u2019s me.", "You\u2019re not alone in those caves, {TARGET}. I\u2019m closer than you think.", "What\u2019s that sound, {TARGET}? Hope it\u2019s not me breaking into your base.", "I know you\u2019ve been digging, {TARGET}. I know what\u2019s buried beneath.", "I\u2019ll find you, {TARGET}. No corner of this world is safe.", "Don\u2019t sleep too soundly, {TARGET}. You never know who\u2019s watching.", "You thought you were safe, didn\u2019t you, {TARGET}? You were wrong.", "You might think you\u2019ve won, {TARGET}, but I\u2019m not done yet.", "You\u2019re running out of places to hide, {TARGET}. I\u2019m everywhere.", "You can\u2019t escape your own fear, {TARGET}. I\u2019ll make sure of that.", "Don\u2019t worry, {TARGET}. I\u2019ll let you know when it\u2019s too late.", "You\u2019ll never see me coming, {TARGET}. But I\u2019ll always be there.", "I\u2019m inside your head now, {TARGET}. You\u2019ll hear me before you see me.", "I know you\u2019re trying to hide, {TARGET}. But I\u2019ve already found you.", "You can run, {TARGET}, but you can\u2019t outrun your own terror.", "Every time you hear a sound, {TARGET}, it\u2019s me getting closer.", "You might think the mobs are bad, but you\u2019ve never met me, {TARGET}.", "I\u2019ll make you regret that decision, {TARGET}. Soon.", "I\u2019ve got your scent, {TARGET}. There\u2019s no escaping now.", "I\u2019m always watching, {TARGET}. Every time you turn around, I\u2019ll be there.", "The longer you hide, {TARGET}, the worse it gets.", "Don\u2019t think the shadows can protect you, {TARGET}. They only make it worse.", "You\u2019ve disturbed something, {TARGET}. And now it\u2019s coming for you.", "I know your every move, {TARGET}. Every dig, every step.", "You\u2019ve forgotten about the past, {TARGET}. I haven\u2019t.", "You can try to run, {TARGET}, but I\u2019ve already set my traps.", "I\u2019m not leaving until I find you, {TARGET}. No matter where you go.", "You should\u2019ve stayed away from that spot, {TARGET}. Now it\u2019s too late.", "I\u2019m the last thing you\u2019ll see, {TARGET}. And you won\u2019t even know when.", "You thought the game was over, {TARGET}? It\u2019s only just begun.", "I\u2019ve marked you, {TARGET}. You can\u2019t escape the mark.", "The longer you stay quiet, the closer I get, {TARGET}.", "I\u2019ve been in your walls for hours, {TARGET}. You never knew.", "You\u2019ve crossed the wrong line, {TARGET}. And now there\u2019s no going back.", "You can\u2019t run from fate, {TARGET}. I\u2019m waiting for you.", "The blocks are listening, {TARGET}. And so am I.", "Every sound you hear is me drawing nearer, {TARGET}.", "You\u2019ll never find the peace you think you will, {TARGET}. Not while I\u2019m around.", "I\u2019ll be in your nightmares soon enough, {TARGET}. You won\u2019t get away from me.", "No matter how fast you dig, {TARGET}, I\u2019ll always be one step ahead.", "You think you\u2019ve made it, {TARGET}, but I\u2019ve already set my sights on you.", "I\u2019m getting closer, {TARGET}. Can you feel it?", "The longer you ignore me, {TARGET}, the worse it\u2019ll be when you finally notice.", "I\u2019m already in your base, {TARGET}. I\u2019m just waiting for you to realize.", "You can hear it, can\u2019t you, {TARGET}? The footsteps behind you.", "I\u2019ve been listening to your every move, {TARGET}. You\u2019re mine now.", "Do you feel it, {TARGET}? The pressure building, the walls closing in.", "It\u2019s not the mobs you need to worry about, {TARGET}. It\u2019s the one hunting you.", "No matter where you dig, {TARGET}, I\u2019ll be right behind you.", "I\u2019ll make sure you regret this, {TARGET}, just wait.", "You\u2019re already too far gone, {TARGET}. I\u2019ve already marked you.", "I\u2019m inside your head now, {TARGET}. You\u2019ll never escape me.", "You can\u2019t escape your own fear, {TARGET}. I\u2019ve already claimed it.", "Your time is running out, {TARGET}. Don\u2019t think you have much left.", "I\u2019m watching you, {TARGET}. Every move. Every breath.", "There\u2019s no escaping me, {TARGET}. I\u2019m coming for you.", "Hello, {TARGET} ;)");

    @Override
    public boolean run(MinecraftServer server) {
        PlayerList playerListManager = server.m_6846_();
        List onlinePlayers = playerListManager.m_11314_();
        if (onlinePlayers.size() < 2) {
            NoSlimesCreepyEvents.logInfo("RandomPlayerThreatenModule: Not enough players online (need >= 2). Skipping.", new Object[0]);
            return false;
        }
        ArrayList selectablePlayers = new ArrayList(onlinePlayers);
        int impersonatedIndex = this.random.nextInt(selectablePlayers.size());
        ServerPlayer impersonated = (ServerPlayer)selectablePlayers.remove(impersonatedIndex);
        int receiverIndex = this.random.nextInt(selectablePlayers.size());
        ServerPlayer receiver = (ServerPlayer)selectablePlayers.get(receiverIndex);
        if (impersonated.f_19853_.m_46472_() != receiver.f_19853_.m_46472_()) {
            NoSlimesCreepyEvents.logInfo("RandomPlayerThreatenModule: Impersonated ({}) and Receiver ({}) are in different dimensions. Skipping.", impersonated.m_7755_().getString(), receiver.m_7755_().getString());
            return false;
        }
        if (impersonated.m_20280_((Entity)receiver) > 2500.0) {
            NoSlimesCreepyEvents.logInfo("RandomPlayerThreatenModule: Receiver ({}) is too far from Impersonated ({}). Skipping.", receiver.m_7755_().getString(), impersonated.m_7755_().getString());
            return false;
        }
        String template = THREAT_TEMPLATES.get(this.random.nextInt(THREAT_TEMPLATES.size()));
        String processedThreat = template.replace("{TARGET}", receiver.m_7755_().getString());
        MutableComponent senderComponent = Component.m_237113_((String)"<");
        senderComponent.m_7220_(impersonated.m_5446_());
        senderComponent.m_7220_((Component)Component.m_237113_((String)"> "));
        senderComponent.m_7220_((Component)Component.m_237113_((String)processedThreat));
        MutableComponent finalFormattedMessage = senderComponent;
        NoSlimesCreepyEvents.logInfo("RandomPlayerThreatenModule: Broadcasting fake message from {} targeting {}: '{}'", impersonated.m_7755_().getString(), receiver.m_7755_().getString(), processedThreat);
        for (ServerPlayer playerToSendTo : onlinePlayers) {
            playerToSendTo.m_213846_((Component)finalFormattedMessage);
        }
        return true;
    }
}

