/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.List;
import java.util.Random;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class RandomSoundPlayerModule
extends EventModule {
    private static final List<SoundEntry> IMPACTFUL_SOUNDS = List.of(RandomSoundPlayerModule.entry(SoundEvents.f_11837_, SoundSource.HOSTILE, 1.0f, 1.5f), RandomSoundPlayerModule.entry(SoundEvents.f_11851_, SoundSource.HOSTILE, 0.8f, 1.2f), RandomSoundPlayerModule.entry(SoundEvents.f_11850_, SoundSource.HOSTILE, 0.9f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_12432_, SoundSource.HOSTILE, 1.0f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12423_, SoundSource.HOSTILE, 1.0f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12598_, SoundSource.HOSTILE, 0.8f, 1.2f), RandomSoundPlayerModule.entry(SoundEvents.f_11922_, SoundSource.HOSTILE, 0.7f, 0.5f), RandomSoundPlayerModule.entry(SoundEvents.f_11924_, SoundSource.HOSTILE, 1.0f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12000_, SoundSource.HOSTILE, 1.0f, 1.3f), RandomSoundPlayerModule.entry(SoundEvents.f_12563_, SoundSource.HOSTILE, 0.6f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12557_, SoundSource.HOSTILE, 0.8f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_12499_, SoundSource.HOSTILE, 1.2f, 1.4f), RandomSoundPlayerModule.entry(SoundEvents.f_215762_, SoundSource.HOSTILE, 1.0f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_215776_, SoundSource.HOSTILE, 0.8f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_215774_, SoundSource.HOSTILE, 1.1f, 1.2f), RandomSoundPlayerModule.entry(SoundEvents.f_12356_, SoundSource.HOSTILE, 0.9f, 0.9f), RandomSoundPlayerModule.entry(SoundEvents.f_11689_, SoundSource.AMBIENT, 0.7f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_11954_, SoundSource.AMBIENT, 0.6f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_12431_, SoundSource.AMBIENT, 0.6f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_12272_, SoundSource.AMBIENT, 0.5f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12084_, SoundSource.RECORDS, 0.4f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12085_, SoundSource.RECORDS, 0.5f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_215750_, SoundSource.HOSTILE, 1.0f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_144129_, SoundSource.BLOCKS, 0.9f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 0.8f), RandomSoundPlayerModule.entry(SoundEvents.f_12056_, SoundSource.BLOCKS, 0.9f, 0.7f), RandomSoundPlayerModule.entry(SoundEvents.f_12626_, SoundSource.BLOCKS, 0.9f, 1.1f), RandomSoundPlayerModule.entry(SoundEvents.f_11749_, SoundSource.BLOCKS, 1.0f, 1.2f), RandomSoundPlayerModule.entry(SoundEvents.f_12312_, SoundSource.BLOCKS, 0.7f, 0.9f), RandomSoundPlayerModule.entry(SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_11874_, SoundSource.HOSTILE, 1.0f, 0.9f), RandomSoundPlayerModule.entry(SoundEvents.f_11983_, SoundSource.BLOCKS, 0.8f, 1.0f), RandomSoundPlayerModule.entry(SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.3f), RandomSoundPlayerModule.entry(SoundEvents.f_11889_, SoundSource.BLOCKS, 0.9f, 1.1f));
    private static final Random RANDOM = new Random();
    private static final float MIN_VOLUME = 0.6f;
    private static final float MAX_VOLUME = 1.1f;
    private static final float MIN_PITCH = 0.7f;
    private static final float MAX_PITCH = 1.3f;
    private static final double MAX_OFFSET = 3.0;

    @Override
    public boolean run(MinecraftServer server) {
        ServerPlayer targetPlayer = this.getRandomPlayer(server);
        if (targetPlayer == null) {
            return false;
        }
        ServerLevel level = targetPlayer.m_9236_();
        SoundEntry soundEntry = IMPACTFUL_SOUNDS.get(RANDOM.nextInt(IMPACTFUL_SOUNDS.size()));
        float randomVolume = 0.6f + RANDOM.nextFloat() * 0.5f;
        float randomPitch = 0.7f + RANDOM.nextFloat() * 0.59999996f;
        double offsetX = (RANDOM.nextDouble() - 0.5) * 2.0 * 3.0;
        double offsetY = (RANDOM.nextDouble() - 0.5) * 1.0 * 3.0;
        double offsetZ = (RANDOM.nextDouble() - 0.5) * 2.0 * 3.0;
        double soundX = targetPlayer.m_20185_() + offsetX;
        double soundY = targetPlayer.m_20186_() + (double)targetPlayer.m_20192_() + offsetY;
        double soundZ = targetPlayer.m_20189_() + offsetZ;
        level.m_6263_(null, soundX, soundY, soundZ, soundEntry.soundEvent, soundEntry.soundSource, soundEntry.baseVolume * randomVolume, soundEntry.basePitch * randomPitch);
        NoSlimesCreepyEvents.logInfo("Played sound {} near player {} with volume {} and pitch {}", soundEntry.soundEvent.m_11660_(), targetPlayer.m_7755_().getString(), Float.valueOf(soundEntry.baseVolume * randomVolume), Float.valueOf(soundEntry.basePitch * randomPitch));
        return true;
    }

    private static SoundEntry entry(SoundEvent event, SoundSource source, float volume, float pitch) {
        return new SoundEntry(event, source, volume, pitch);
    }

    private static class SoundEntry {
        final SoundEvent soundEvent;
        final SoundSource soundSource;
        final float baseVolume;
        final float basePitch;

        SoundEntry(SoundEvent event, SoundSource source, float volume, float pitch) {
            this.soundEvent = event;
            this.soundSource = source;
            this.baseVolume = volume;
            this.basePitch = pitch;
        }
    }
}

