/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import com.noslimes.noslimes_creepy_events.util.MobStareHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;

public class RandomTalkerModule
extends EventModule {
    private static final String[] MESSAGES = new String[]{"I \u00a7ksee\u00a7r\u00a74 you...", "You're not \u00a7kalone\u00a7r\u00a78...", "Can't run \u00a7kforever\u00a7r\u00a7c...", "\u00a7kDon't\u00a7r\u00a74 turn around...", "Always \u00a7kwatching\u00a7r\u00a78...", "\u00a7kGet out\u00a7r\u00a7c... while you can...", "\u00a7oI can still see you...\u00a7r\u00a74", "\u00a7oNever alone...\u00a7r\u00a78", "\u00a7oNowhere to run...\u00a7r\u00a7c", "\u00a7oBehind you...\u00a7r\u00a74", "\u00a7oStill watching...\u00a7r\u00a78", "\u00a7oLeave... \u00a7kNOW\u00a7r\u00a7c...\u00a7r", "\u00a7kWatching\u00a7r\u00a78 from the dark.", "I see your \u00a7kshadow\u00a7r\u00a74.", "Your \u00a7klight\u00a7r\u00a7c flickers...", "\u00a7oDid you hear that?\u00a7r\u00a78", "\u00a7oEvery step echoes...\u00a7r\u00a74", "\u00a7oAre you sleeping?\u00a7r\u00a7c", "\u00a7kFound\u00a7r\u00a7c you again.", "\u00a7oYou dropped something precious...\u00a7r\u00a78", "\u00a7oYour heart beats \u00a7kso loud\u00a7r\u00a7c.", "\u00a7oNice \u00a7kplace\u00a7r\u00a74 you have here...", "\u00a7oI know what you \u00a7kmined\u00a7r\u00a78.", "\u00a7oCloser than you think.\u00a7r\u00a74", "\u00a7oPeeking...\u00a7r\u00a7c", "\u00a7oThe walls have \u00a7keyes\u00a7r\u00a78...", "\u00a7oThrough the cracks...\u00a7r\u00a74", "\u00a7kRun.\u00a7r\u00a7c", "It's \u00a7ktoo late\u00a7r\u00a74 for you.", "\u00a7kTime's up\u00a7r\u00a7c.", "\u00a7oYou shouldn't have come \u00a7khere\u00a7r\u00a74.", "\u00a7oThere is no \u00a7kescape\u00a7r\u00a7c this time.", "\u00a7kClose\u00a7r\u00a78 your \u00a7keyes\u00a7r\u00a74... tight.", "\u00a7oThe \u00a7kdarkness\u00a7r\u00a78 consumes.", "\u00a7oIt \u00a7khungers\u00a7r\u00a74.", "\u00a7oYour end is \u00a7knigh\u00a7r\u00a7c.", "\u00a7oDon't \u00a7kscream\u00a7r\u00a74. No one can hear.", "\u00a7oIt hurts... doesn't it?\u00a7r\u00a7c", "\u00a7oYou'll join \u00a7kus\u00a7r\u00a78 soon enough.", "\u00a7oSilence approaches.\u00a7r\u00a74", "\u00a7oThe \u00a7kdepths\u00a7r\u00a7c await.", "\u00a7oYour torch won't last.\u00a7r\u00a78", "\u00a7oIs this \u00a7kreal\u00a7r\u00a78?", "\u00a7oAre you \u00a7ksure\u00a7r\u00a74 you're alone?", "\u00a7oIt's all in your \u00a7khead\u00a7r\u00a7c... or is it?", "\u00a7oThat wasn't the \u00a7kwind\u00a7r\u00a78.", "\u00a7oThey \u00a7klie\u00a7r\u00a74 to you constantly.", "\u00a7oTrust \u00a7knothing\u00a7r\u00a7c down here.", "\u00a7oWhy are you \u00a7kafraid\u00a7r\u00a78?", "\u00a7oDo you remember \u00a7kthis place\u00a7r\u00a74?", "\u00a7oForget what you \u00a7ksaw\u00a7r\u00a7c.", "\u00a7oIt remembers \u00a7kyou\u00a7r\u00a74, though.", "\u00a7oJust a \u00a7kglitch\u00a7r\u00a78 in the code...", "\u00a7oSomething's \u00a7kwrong\u00a7r\u00a7c...", "\u00a7oDid you forget \u00a7ksomething\u00a7r\u00a74?", "\u00a7k...He comes...\u00a7r\u00a74", "\u00a7kTicking... ticking...\u00a7r\u00a7c", "\u00a7oListen to the \u00a7ksilence\u00a7r\u00a78.", "\u00a7oScratching... \u00a7kscratching\u00a7r\u00a74 from below.", "\u00a7oIt's so \u00a7kcold\u00a7r\u00a78 here.", "\u00a7oThe \u00a7kstatic\u00a7r\u00a7c grows louder.", "\u00a7oBreathing... but not yours...\u00a7r\u00a74", "\u00a7oRot... and decay...\u00a7r\u00a78", "\u00a7kThump... thump...\u00a7r\u00a7c goes the heart.", "\u00a7oEmpty... hollow...\u00a7r\u00a74", "\u00a7oDrip... drip... drip...\u00a7r\u00a78", "\u00a7oWhispers in the \u00a7kstone\u00a7r\u00a74...", "\u00a7k...Lost...\u00a7r\u00a7c", "\u00a7kMine.\u00a7r\u00a7c", "\u00a7oYou belong \u00a7khere\u00a7r\u00a74 now.", "\u00a7oStay with \u00a7kus\u00a7r\u00a78 forever.", "\u00a7oDon't \u00a7kleave\u00a7r\u00a7c me.", "\u00a7oI \u00a7kneed\u00a7r\u00a74 your fear.", "\u00a7oLet me \u00a7kin\u00a7r\u00a7c.", "\u00a7oJust a little \u00a7kcloser\u00a7r\u00a78..."};
    private static final int STARE_DURATION_TICKS = 60;
    private static final int EFFECT_DURATION_TICKS = 80;

    @Override
    public boolean run(MinecraftServer server) {
        if (server == null) {
            return false;
        }
        ServerPlayer targetPlayer = this.getRandomPlayer(server);
        if (targetPlayer == null) {
            return false;
        }
        ServerLevel level = targetPlayer.m_9236_();
        AABB searchArea = new AABB(targetPlayer.m_20183_()).m_82400_(15.0);
        List nearbyMobs = level.m_6443_(Mob.class, searchArea, entity -> !entity.m_213877_() && entity.m_142582_((Entity)targetPlayer));
        ArrayList<Mob> hostiles = new ArrayList<Mob>();
        ArrayList<Mob> passives = new ArrayList<Mob>();
        for (Mob mob : nearbyMobs) {
            if (mob instanceof Monster) {
                hostiles.add(mob);
                continue;
            }
            passives.add(mob);
        }
        if (hostiles.isEmpty() && passives.isEmpty()) {
            return false;
        }
        ArrayList<Mob> pickFrom = !hostiles.isEmpty() ? hostiles : passives;
        Mob stalkingMob = (Mob)pickFrom.get(this.random.nextInt(pickFrom.size()));
        level.m_6263_(null, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), SoundEvents.f_12499_, SoundSource.HOSTILE, 1.0f, 0.7f + this.random.nextFloat() * 0.4f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, stalkingMob.m_20208_(0.8), stalkingMob.m_20187_(), stalkingMob.m_20262_(0.8), 15, 0.2, 0.3, 0.2, 0.01);
        targetPlayer.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 80, 0, true, false));
        boolean didStartStare = MobStareHandler.startStare(stalkingMob, (LivingEntity)targetPlayer, 60);
        if (!didStartStare) {
            NoSlimesCreepyEvents.LOGGER.warn("Could not start stalking stare for mob {} (already staring or invalid?).", (Object)stalkingMob.m_20148_());
            return false;
        }
        targetPlayer.m_7618_(EntityAnchorArgument.Anchor.EYES, stalkingMob.m_146892_());
        String rawMessage = MESSAGES[this.random.nextInt(MESSAGES.length)];
        MutableComponent whisperMessage = Component.m_237113_((String)("<" + stalkingMob.m_7755_().getString() + "> ")).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237113_((String)rawMessage).m_130940_(ChatFormatting.ITALIC));
        targetPlayer.m_240418_((Component)whisperMessage, false);
        NoSlimesCreepyEvents.logInfo("Mob {} started stalking stare at {}. Stop scheduled.", stalkingMob.m_20148_(), targetPlayer.m_20148_());
        return true;
    }
}

