/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.noslimes.noslimes_creepy_events.Config;
import com.noslimes.noslimes_creepy_events.EventCaller;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModCommands {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(ModCommands.class);
        NoSlimesCreepyEvents.logInfo("ModCommands registered successfully.", new Object[0]);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"creepyevents").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"interval").then(Commands.m_82129_((String)"minInterval", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"maxInterval", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int maxInterval;
            int minInterval = IntegerArgumentType.getInteger((CommandContext)context, (String)"minInterval");
            if (minInterval >= (maxInterval = IntegerArgumentType.getInteger((CommandContext)context, (String)"maxInterval"))) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Error: Minimum interval must be less than maximum interval."));
                return 0;
            }
            boolean success = Config.setRandomInterval(minInterval, maxInterval);
            if (success) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Successfully set random interval to [" + minInterval + ", " + maxInterval + "] ticks.")), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to set interval. Check logs for details. Ensure values are valid."));
            return 0;
        }))))).then(Commands.m_82127_((String)"chance").then(Commands.m_82129_((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
            int chance = IntegerArgumentType.getInteger((CommandContext)context, (String)"chance");
            boolean success = Config.setRandomChance(chance);
            if (success) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Successfully set random chance to " + chance)), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to set chance. Check logs for details. Ensure value is within range."));
            return 0;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"interval").executes(context -> {
            int minVal = Config.randomIntervalMin;
            int maxVal = Config.randomIntervalMax;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Current random interval: [" + minVal + ", " + maxVal + "] ticks.")), false);
            return 1;
        }))).then(Commands.m_82127_((String)"chance").executes(context -> {
            double chanceVal = Config.randomChance;
            String chanceText = String.format("%.2f", chanceVal);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Current random chance: " + chanceText)), false);
            return 1;
        })))).then(Commands.m_82127_((String)"skipInterval").executes(context -> {
            try {
                EventCaller.skipInterval();
                NoSlimesCreepyEvents.LOGGER.info("CREEPYEVENTS: EventCaller.runNow() seems to have executed.");
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Forced next event execution. Will trigger on next server tick."), true);
                return 1;
            }
            catch (Exception e) {
                NoSlimesCreepyEvents.LOGGER.error("CREEPYEVENTS: Error during runNow execution:", (Throwable)e);
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Error executing runNow. Check server logs."));
                return 0;
            }
        })));
    }
}

