/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.util;

import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpinHandler {
    private static final Map<UUID, SpinData> spinningPlayers = new HashMap<UUID, SpinData>();
    private static boolean isListenerRegistered = false;

    public static void startSpinning(ServerPlayer player, float totalRotationDegrees, int durationTicks) {
        if (player == null || durationTicks <= 0) {
            return;
        }
        float yawChangePerTick = totalRotationDegrees / (float)durationTicks;
        spinningPlayers.put(player.m_20148_(), new SpinData(yawChangePerTick, durationTicks));
        SpinHandler.registerListener();
    }

    private static void registerListener() {
        if (!isListenerRegistered) {
            MinecraftForge.EVENT_BUS.register(SpinHandler.class);
            isListenerRegistered = true;
            NoSlimesCreepyEvents.logInfo("SpinHandler Registered", new Object[0]);
        }
    }

    private static void unregisterListener() {
        if (isListenerRegistered && spinningPlayers.isEmpty()) {
            MinecraftForge.EVENT_BUS.unregister(SpinHandler.class);
            isListenerRegistered = false;
            NoSlimesCreepyEvents.logInfo("SpinHandler Unregistered", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<UUID, SpinData>> iterator = spinningPlayers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, SpinData> entry = iterator.next();
                UUID playerUUID = entry.getKey();
                SpinData data = entry.getValue();
                ServerPlayer player = event.getServer().m_6846_().m_11259_(playerUUID);
                if (player != null && data.ticksRemaining > 0) {
                    float currentYaw = player.m_146908_();
                    float newYaw = currentYaw + data.yawChangePerTick;
                    player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), newYaw, player.m_146909_());
                    --data.ticksRemaining;
                    if (data.ticksRemaining > 0) continue;
                    iterator.remove();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private static class SpinData {
        float yawChangePerTick;
        int ticksRemaining;

        SpinData(float yawChangePerTick, int ticksRemaining) {
            this.yawChangePerTick = yawChangePerTick;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

