/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.noslimes.noslimes_creepy_events.Config;
import com.noslimes.noslimes_creepy_events.EventCaller;
import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.EventModules.PuppetPlayerModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModCommands {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(ModCommands.class);
        NoSlimesCreepyEvents.logInfo("ModCommands registered successfully.", new Object[0]);
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder<CommandSourceStack> runModuleCommand = ModCommands.genRunCommand();
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"creepyevents").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"interval").then(Commands.m_82129_((String)"minInterval", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"maxInterval", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            int maxInterval;
            int minInterval = IntegerArgumentType.getInteger((CommandContext)context, (String)"minInterval");
            if (minInterval >= (maxInterval = IntegerArgumentType.getInteger((CommandContext)context, (String)"maxInterval"))) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Error: Minimum interval must be less than maximum interval."));
                return 0;
            }
            boolean success = Config.setRandomInterval(minInterval, maxInterval);
            if (success) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Successfully set random interval to [" + minInterval + ", " + maxInterval + "] ticks.")), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to set interval. Check logs for details. Ensure values are valid."));
            return 0;
        }))))).then(Commands.m_82127_((String)"chance").then(Commands.m_82129_((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> {
            int chance = IntegerArgumentType.getInteger((CommandContext)context, (String)"chance");
            boolean success = Config.setRandomChance(chance);
            if (success) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Successfully set random chance to " + chance)), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to set chance. Check logs for details. Ensure value is within range."));
            return 0;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(Commands.m_82127_((String)"interval").executes(context -> {
            int minVal = Config.randomIntervalMin;
            int maxVal = Config.randomIntervalMax;
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Current random interval: [" + minVal + ", " + maxVal + "] ticks.")), false);
            return 1;
        }))).then(Commands.m_82127_((String)"chance").executes(context -> {
            double chanceVal = Config.randomChance;
            String chanceText = String.format("%.2f", chanceVal);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Current random chance: " + chanceText)), false);
            return 1;
        })))).then(Commands.m_82127_((String)"skipInterval").executes(context -> {
            try {
                EventCaller.getInstance().skipInterval();
                NoSlimesCreepyEvents.LOGGER.info("CREEPYEVENTS: EventCaller.runNow() seems to have executed.");
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Forced next event execution. Will trigger on next server tick."), true);
                return 1;
            }
            catch (Exception e) {
                NoSlimesCreepyEvents.LOGGER.error("CREEPYEVENTS: Error during runNow execution:", (Throwable)e);
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Error executing runNow. Check server logs."));
                return 0;
            }
        }))).then(Commands.m_82127_((String)"module").then(runModuleCommand)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> genRunCommand() {
        LiteralArgumentBuilder runCommand = Commands.m_82127_((String)"run");
        Set<EventModule> eventModules = EventCaller.getInstance().getModules();
        for (EventModule eventModule : eventModules) {
            String commandName = ModCommands.formatModuleCommandName(eventModule.getClass().getSimpleName());
            LiteralArgumentBuilder moduleCommand = Commands.m_82127_((String)commandName);
            moduleCommand = (LiteralArgumentBuilder)moduleCommand.then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
                MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
                Collection targets = EntityArgument.m_91477_((CommandContext)context, (String)"targets");
                for (ServerPlayer p : targets) {
                    eventModule.run(server, p);
                }
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Executed module: " + commandName + " on " + targets.size() + " player(s)")), true);
                return targets.size();
            }));
            if (eventModule instanceof PuppetPlayerModule) {
                PuppetPlayerModule puppet = (PuppetPlayerModule)eventModule;
                moduleCommand = (LiteralArgumentBuilder)moduleCommand.then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
                    MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
                    Collection targets = EntityArgument.m_91477_((CommandContext)context, (String)"targets");
                    int duration = IntegerArgumentType.getInteger((CommandContext)context, (String)"durationTicks");
                    for (ServerPlayer p : targets) {
                        puppet.run(server, p, duration);
                    }
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Executed puppet module: " + commandName + " with duration " + duration + " on " + targets.size() + " player(s)")), true);
                    return targets.size();
                })));
            }
            moduleCommand = (LiteralArgumentBuilder)moduleCommand.executes(context -> {
                MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
                eventModule.run(server, null);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Executed module: " + commandName + " on default player(s)")), true);
                return 1;
            });
            runCommand.then((ArgumentBuilder)moduleCommand);
        }
        return runCommand;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> genSetStateCommand() {
        LiteralArgumentBuilder setStateCommand;
        block0: {
            setStateCommand = Commands.m_82127_((String)"run");
            Set<EventModule> eventModules = EventCaller.getInstance().getModules();
            Iterator<EventModule> iterator = eventModules.iterator();
            if (!iterator.hasNext()) break block0;
            EventModule eventModule = iterator.next();
        }
        return setStateCommand;
    }

    private static String formatModuleCommandName(String className) {
        if (className.endsWith("Module")) {
            className = className.substring(0, className.length() - "Module".length());
        }
        StringBuilder formatted = new StringBuilder();
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                formatted.append('_');
            }
            formatted.append(Character.toLowerCase(c));
        }
        return formatted.toString();
    }
}

