/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.util;

import com.google.common.collect.Maps;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class MobStareHandler {
    private static final ConcurrentMap<UUID, StareData> staringMobs = Maps.newConcurrentMap();
    private static long currentServerTick = 0L;
    private static boolean isListenerRegistered = false;

    private static void registerHandler() {
        if (!isListenerRegistered) {
            MinecraftForge.EVENT_BUS.register(MobStareHandler.class);
            NoSlimesCreepyEvents.logInfo("MobStareHandler registered for server ticks.", new Object[0]);
            isListenerRegistered = true;
        }
    }

    public static boolean startStare(Mob staringMob, LivingEntity targetEntity, int durationTicks) {
        if (durationTicks <= 0 || staringMob == null || !staringMob.m_6084_() || staringMob.f_19853_.m_5776_() || targetEntity == null || !targetEntity.m_6084_()) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to start stare with invalid parameters: mob={}, target={}, duration={}", new Object[]{staringMob, targetEntity, durationTicks});
            return false;
        }
        if (staringMobs.containsKey(staringMob.m_20148_())) {
            NoSlimesCreepyEvents.logInfo("Mob {} is already staring, ignoring new request.", staringMob.m_20148_());
            return false;
        }
        LivingEntity originalTarget = staringMob.m_5448_();
        boolean originalInvulnerability = staringMob.m_20147_();
        long endTick = currentServerTick + (long)durationTicks;
        StareData data = new StareData(staringMob, targetEntity, originalTarget, originalInvulnerability, endTick);
        MobStareHandler.applyStareEffects(staringMob, data);
        staringMobs.put(staringMob.m_20148_(), data);
        NoSlimesCreepyEvents.logInfo("Started stare: Mob {} -> Target {} for {} ticks (until tick {})", staringMob.m_20148_(), targetEntity.m_20148_(), durationTicks, endTick);
        MobStareHandler.registerHandler();
        return true;
    }

    public static boolean stopStare(Mob staringMob) {
        if (staringMob == null) {
            return false;
        }
        return MobStareHandler.stopStare(staringMob.m_20148_());
    }

    public static boolean stopStare(UUID mobUUID) {
        StareData data = (StareData)staringMobs.remove(mobUUID);
        if (data != null) {
            NoSlimesCreepyEvents.logInfo("Manually stopping stare for mob {}", mobUUID);
            MobStareHandler.restoreMobState(data.getMob(), data);
            return true;
        }
        return false;
    }

    public static boolean isStaring(Mob mob) {
        return mob != null && staringMobs.containsKey(mob.m_20148_());
    }

    private static void applyStareEffects(Mob mob, StareData data) {
        mob.m_21573_().m_26573_();
        mob.m_6710_(null);
        mob.m_21557_(true);
        data.aiWasDisabled = true;
        mob.m_20331_(true);
        LivingEntity target = data.getTarget();
        if (target != null) {
            MobStareHandler.updateLookDirection(mob, target);
        }
    }

    private static void restoreMobState(@Nullable Mob mob, StareData data) {
        if (mob == null || !mob.m_6084_() || mob.m_213877_()) {
            NoSlimesCreepyEvents.logInfo("Cannot restore state for mob {} (invalid or removed)", data.mobUUID);
            staringMobs.remove(data.mobUUID);
            return;
        }
        NoSlimesCreepyEvents.logInfo("Restoring state for mob {} after stare.", mob.m_20148_());
        if (data.aiWasDisabled) {
            mob.m_21557_(false);
        }
        mob.m_20331_(data.originalInvulnerability);
        LivingEntity originalTarget = data.originalTarget;
        if (originalTarget != null && originalTarget.m_6084_() && !originalTarget.m_213877_()) {
            if (TargetingConditions.f_26872_.m_26885_((LivingEntity)mob, originalTarget)) {
                mob.m_6710_(originalTarget);
            } else {
                mob.m_6710_(null);
            }
        } else {
            mob.m_6710_(null);
        }
    }

    private static void updateLookDirection(Mob mob, LivingEntity target) {
        mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
        if (!mob.m_21573_().m_26571_()) {
            mob.m_21573_().m_26573_();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ++currentServerTick;
        if (staringMobs.isEmpty()) {
            return;
        }
        staringMobs.entrySet().removeIf(entry -> {
            UUID mobUUID = (UUID)entry.getKey();
            StareData data = (StareData)entry.getValue();
            Mob mob = data.getMob();
            LivingEntity target = data.getTarget();
            boolean remove = false;
            String reason = "";
            if (mob == null || !mob.m_6084_() || mob.m_213877_()) {
                remove = true;
                reason = "Staring mob invalid/removed";
            } else if (target == null || !target.m_6084_() || target.m_213877_() || target.f_19853_ != mob.f_19853_) {
                remove = true;
                reason = "Target entity invalid/removed/wrong level";
            } else if (currentServerTick >= data.endTick) {
                remove = true;
                reason = "Stare duration ended";
            }
            if (remove) {
                NoSlimesCreepyEvents.logInfo("Stopping stare for mob {}: {}", mobUUID, reason);
                MobStareHandler.restoreMobState(mob, data);
                return true;
            }
            MobStareHandler.updateLookDirection(mob, target);
            return false;
        });
    }

    private static class StareData {
        final UUID mobUUID;
        final WeakReference<Mob> mobRef;
        final WeakReference<LivingEntity> targetRef;
        final long endTick;
        @Nullable
        final LivingEntity originalTarget;
        final boolean originalInvulnerability;
        boolean aiWasDisabled;

        StareData(Mob mob, LivingEntity target, @Nullable LivingEntity originalTarget, boolean originalInvulnerability, long endTick) {
            this.mobUUID = mob.m_20148_();
            this.mobRef = new WeakReference<Mob>(mob);
            this.targetRef = new WeakReference<LivingEntity>(target);
            this.originalTarget = originalTarget;
            this.originalInvulnerability = originalInvulnerability;
            this.endTick = endTick;
            this.aiWasDisabled = false;
        }

        @Nullable
        Mob getMob() {
            return (Mob)this.mobRef.get();
        }

        @Nullable
        LivingEntity getTarget() {
            return (LivingEntity)this.targetRef.get();
        }
    }
}

