/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.util;

import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import com.noslimes.noslimes_creepy_events.ai.goals.InfiniteFollowGoal;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum PuppetPlayerHandler {
    INSTANCE;

    public static final String PUPPET_ENTITY_TAG = "puppet_entity";
    private final Map<UUID, ControlTask> tasks = new ConcurrentHashMap<UUID, ControlTask>();

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void startControl(ServerPlayer hunter, ServerPlayer victim, int durationTicks) {
        if (hunter == null || victim == null || hunter.f_19853_ == null || hunter == victim) {
            NoSlimesCreepyEvents.LOGGER.warn("PuppetPlayerHandler: Invalid hunter or victim provided.");
            return;
        }
        ServerLevel level = hunter.m_9236_();
        if (level == null) {
            NoSlimesCreepyEvents.LOGGER.error("PuppetPlayerHandler: Hunter's level is null during startControl!");
            return;
        }
        if (level != victim.f_19853_) {
            NoSlimesCreepyEvents.LOGGER.warn("PuppetPlayerHandler: Hunter and victim are in different dimensions.");
            return;
        }
        this.stopControl(hunter.m_20148_(), hunter.m_20194_());
        ControlTask task = new ControlTask(hunter, victim, durationTicks);
        if (task.initializePuppetEntity(level, hunter, victim)) {
            this.tasks.put(hunter.m_20148_(), task);
            NoSlimesCreepyEvents.logInfo("Started controlling player {} to hunt {} (Duration: {} ticks)", hunter.m_7755_().getString(), victim.m_7755_().getString(), task.isInfinite ? "Infinite" : Integer.valueOf(durationTicks));
        } else {
            NoSlimesCreepyEvents.LOGGER.error("Failed to initialize PuppetEntity for player control task (hunter: {}, victim: {}, level: {}).", new Object[]{hunter.m_7755_().getString(), victim.m_7755_().getString(), level.m_46472_().m_135782_()});
        }
    }

    public void stopControl(ServerPlayer hunter) {
        if (hunter != null) {
            this.stopControl(hunter.m_20148_(), hunter.m_20194_());
        }
    }

    public void stopControl(UUID hunterUUID, MinecraftServer server) {
        ControlTask oldTask = this.tasks.remove(hunterUUID);
        if (oldTask != null) {
            ServerPlayer hunter;
            if (server != null) {
                oldTask.cleanUp(server);
            } else {
                NoSlimesCreepyEvents.LOGGER.warn("Could not get server instance to clean up task for {}", (Object)hunterUUID);
                oldTask.cleanUp(null);
            }
            NoSlimesCreepyEvents.logInfo("Stopped controlling player with UUID {}", hunterUUID);
            ServerPlayer serverPlayer = hunter = server != null ? oldTask.getHunter(server) : null;
            if (hunter == null || hunter.m_6084_()) {
                // empty if block
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.getServer() == null) {
            return;
        }
        MinecraftServer server = event.getServer();
        this.tasks.entrySet().removeIf(entry -> {
            boolean shouldRemove;
            ControlTask task = (ControlTask)entry.getValue();
            ServerLevel taskLevel = server.m_129880_(task.dimension);
            if (taskLevel == null) {
                NoSlimesCreepyEvents.LOGGER.warn("Task for hunter {} is in a level ({}) that is not loaded/found on the server. Removing task.", (Object)task.hunterUUID, (Object)task.dimension.m_135782_());
                shouldRemove = true;
            } else {
                boolean bl = shouldRemove = !task.tick(taskLevel, server);
            }
            if (shouldRemove) {
                task.cleanUp(server);
                NoSlimesCreepyEvents.logInfo("Removing completed/invalid task for hunter {}", task.hunterUUID);
            }
            return shouldRemove;
        });
    }

    @SubscribeEvent
    public void onPlayerMessage(ServerChatEvent event) {
        ServerPlayer sender = event.getPlayer();
        if (this.tasks.containsKey(sender.m_20148_())) {
            event.setCanceled(true);
            String original = event.getMessage().getString();
            String obfuscatedMessage = "\u00a7k" + original + "\u00a7r";
            MutableComponent fakeMessage = Component.m_237113_((String)("<" + sender.m_7755_().getString() + "> ")).m_7220_((Component)Component.m_237113_((String)obfuscatedMessage));
            sender.m_20194_().m_6846_().m_240416_((Component)fakeMessage, false);
        }
    }

    private static class ControlTask {
        private static final int ATTACK_INTERVAL = 20;
        private static final double MAX_ATTACK_DIST_SQ = 9.0;
        private static final double VINDICATOR_FOLLOW_SPEED = 1.0;
        final UUID hunterUUID;
        final UUID victimUUID;
        final ResourceKey<Level> dimension;
        final boolean isInfinite;
        UUID puppetEntityUUID;
        int ticksRemaining;
        long lastAttackTickGameTime;
        boolean puppetEntityInitialized = false;

        ControlTask(ServerPlayer hunter, ServerPlayer victim, int ticks) {
            this.hunterUUID = hunter.m_20148_();
            this.victimUUID = victim.m_20148_();
            this.dimension = hunter.f_19853_.m_46472_();
            this.isInfinite = ticks == 0;
            this.ticksRemaining = ticks;
            this.lastAttackTickGameTime = hunter.f_19853_.m_46467_() - 20L;
        }

        boolean initializePuppetEntity(ServerLevel level, ServerPlayer hunter, ServerPlayer victim) {
            if (level == null || hunter == null || victim == null) {
                NoSlimesCreepyEvents.LOGGER.error("initializePuppetEntity received null parameter(s).");
                return false;
            }
            Vindicator puppetEntity = new Vindicator(EntityType.f_20493_, (Level)level);
            if (puppetEntity == null) {
                NoSlimesCreepyEvents.LOGGER.error("initializePuppetEntity: Failed to instantiate PuppetEntity!");
                return false;
            }
            puppetEntity.m_6034_(hunter.m_20185_(), hunter.m_20186_(), hunter.m_20189_());
            puppetEntity.m_21530_();
            puppetEntity.m_6842_(true);
            puppetEntity.m_20225_(true);
            puppetEntity.m_20331_(true);
            for (BlockPathTypes type : BlockPathTypes.values()) {
                float defaultMalus = puppetEntity.m_21439_(type);
                puppetEntity.m_21441_(type, defaultMalus);
            }
            puppetEntity.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
            puppetEntity.m_21441_(BlockPathTypes.DOOR_OPEN, 0.0f);
            GroundPathNavigation nav = (GroundPathNavigation)puppetEntity.m_21573_();
            nav.m_26477_(true);
            nav.m_148214_(true);
            CompoundTag nbt = new CompoundTag();
            puppetEntity.m_7380_(nbt);
            nbt.m_128359_("DeathLootTable", "minecraft:empty");
            puppetEntity.m_7378_(nbt);
            puppetEntity.f_21345_.m_148096_();
            puppetEntity.f_21346_.m_148096_();
            float stopDistance = 2.0f;
            puppetEntity.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)puppetEntity));
            puppetEntity.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)puppetEntity, true));
            puppetEntity.f_21345_.m_25352_(2, (Goal)new InfiniteFollowGoal((PathfinderMob)puppetEntity, (LivingEntity)victim, 1.0, stopDistance));
            puppetEntity.m_6710_((LivingEntity)victim);
            puppetEntity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false));
            puppetEntity.getPersistentData().m_128379_(PuppetPlayerHandler.PUPPET_ENTITY_TAG, true);
            if (level.m_7967_((Entity)puppetEntity)) {
                this.puppetEntityUUID = puppetEntity.m_20148_();
                this.puppetEntityInitialized = true;
                NoSlimesCreepyEvents.logInfo("Spawned PuppetEntity {} for task", this.puppetEntityUUID);
                return true;
            }
            NoSlimesCreepyEvents.LOGGER.error("level.addFreshEntity(puppetEntity) returned false. PuppetEntity: {}, Pos: {}, ChunkLoaded: {}", new Object[]{puppetEntity, puppetEntity.m_20182_(), level.m_46749_(puppetEntity.m_20183_())});
            return false;
        }

        boolean tick(ServerLevel level, MinecraftServer server) {
            long now;
            double distSq;
            if (!this.puppetEntityInitialized) {
                if (this.puppetEntityUUID != null) {
                    NoSlimesCreepyEvents.logInfo("Task stopping: Puppet entity not found or previously removed for hunter {}", this.hunterUUID);
                }
                return false;
            }
            if (!this.isInfinite && this.ticksRemaining-- <= 0) {
                NoSlimesCreepyEvents.logInfo("Task stopping: Time ran out for hunter {}", this.hunterUUID);
                return false;
            }
            ServerPlayer hunter = this.getHunter(server);
            ServerPlayer victim = this.getVictim(server);
            Vindicator puppetEntity = this.getPuppetEntity(level);
            if (!(hunter != null && hunter.m_6084_() && victim != null && victim.m_6084_() && puppetEntity != null && puppetEntity.m_6084_())) {
                Object[] objectArray = new Object[3];
                Object object = hunter == null ? "null" : (objectArray[0] = hunter.m_6084_() ? "alive" : "dead");
                Object object2 = victim == null ? "null" : (objectArray[1] = victim.m_6084_() ? "alive" : "dead");
                objectArray[2] = puppetEntity == null ? "null" : (puppetEntity.m_6084_() ? "alive" : "dead");
                NoSlimesCreepyEvents.logInfo("Task stopping: Hunter ({}), Victim ({}), or PuppetEntity ({}) invalid/dead.", objectArray);
                return false;
            }
            if (hunter.f_19853_.m_46472_() != this.dimension || victim.f_19853_.m_46472_() != this.dimension || puppetEntity.f_19853_.m_46472_() != this.dimension) {
                NoSlimesCreepyEvents.logInfo("Task stopping: Entity changed dimension unexpectedly. Hunter: {}, Victim: {}, Puppet: {}", hunter.f_19853_.m_46472_().m_135782_(), victim.f_19853_.m_46472_().m_135782_(), puppetEntity.f_19853_.m_46472_().m_135782_());
                return false;
            }
            if (puppetEntity.m_5448_() != victim) {
                NoSlimesCreepyEvents.LOGGER.warn("PuppetEntity {} lost target, re-targeting {}", (Object)this.puppetEntityUUID, (Object)this.victimUUID);
                puppetEntity.m_6710_((LivingEntity)victim);
            }
            Vec3 PuppetEntityPos = puppetEntity.m_20182_();
            hunter.m_8999_(level, PuppetEntityPos.f_82479_, PuppetEntityPos.f_82480_, PuppetEntityPos.f_82481_, hunter.m_146908_(), hunter.m_146909_());
            Vec3 hunterPos = hunter.m_20182_();
            Vec3 diff = victim.m_146892_().m_82546_(hunter.m_146892_());
            if (diff.m_165925_() > 1.0E-6) {
                float targetYaw = (float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 57.29577951308232) - 90.0f;
                double horizontalDist = Math.sqrt(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_);
                float targetPitch = (float)(-(Math.atan2(diff.f_82480_, horizontalDist) * 57.29577951308232));
                hunter.m_8999_(level, hunter.m_20185_(), hunter.m_20186_(), hunter.m_20189_(), targetYaw, targetPitch);
                hunter.m_5616_(targetYaw);
            }
            if ((distSq = hunter.m_20280_((Entity)victim)) <= 9.0 && hunter.m_142582_((Entity)victim) && (now = level.m_46467_()) - this.lastAttackTickGameTime >= 20L) {
                if (hunter.m_21255_()) {
                    hunter.m_36321_();
                }
                hunter.m_6674_(InteractionHand.MAIN_HAND);
                hunter.m_5706_((Entity)victim);
                this.lastAttackTickGameTime = now;
            }
            return true;
        }

        void cleanUp(MinecraftServer server) {
            if (this.puppetEntityInitialized && this.puppetEntityUUID != null) {
                if (server != null) {
                    ServerLevel level = server.m_129880_(this.dimension);
                    if (level != null) {
                        Vindicator vindicator = this.getPuppetEntity(level);
                        if (vindicator != null) {
                            NoSlimesCreepyEvents.logInfo("Cleaning up PuppetEntity {}", this.puppetEntityUUID);
                            vindicator.m_142467_(Entity.RemovalReason.DISCARDED);
                        } else {
                            NoSlimesCreepyEvents.LOGGER.warn("Could not find PuppetEntity {} in level {} during cleanup.", (Object)this.puppetEntityUUID, (Object)this.dimension.m_135782_());
                        }
                    } else {
                        NoSlimesCreepyEvents.LOGGER.warn("Could not find level {} during cleanup for PuppetEntity {}.", (Object)this.dimension.m_135782_(), (Object)this.puppetEntityUUID);
                    }
                } else {
                    NoSlimesCreepyEvents.LOGGER.warn("Cleanup called for {} but server instance was null. PuppetEntity might remain.", (Object)this.puppetEntityUUID);
                }
            }
            this.puppetEntityInitialized = false;
            this.puppetEntityUUID = null;
        }

        ServerPlayer getHunter(MinecraftServer server) {
            ServerPlayer p;
            if (server == null) {
                return null;
            }
            ServerLevel level = server.m_129880_(this.dimension);
            if (level == null) {
                return null;
            }
            Entity entity = level.m_8791_(this.hunterUUID);
            return entity instanceof ServerPlayer && (p = (ServerPlayer)entity).m_6084_() ? p : null;
        }

        ServerPlayer getVictim(MinecraftServer server) {
            ServerPlayer p;
            if (server == null) {
                return null;
            }
            ServerLevel level = server.m_129880_(this.dimension);
            if (level == null) {
                return null;
            }
            Entity entity = level.m_8791_(this.victimUUID);
            return entity instanceof ServerPlayer && (p = (ServerPlayer)entity).m_6084_() ? p : null;
        }

        Vindicator getPuppetEntity(ServerLevel level) {
            Vindicator v;
            if (this.puppetEntityUUID == null || level == null) {
                return null;
            }
            if (level.m_46472_() != this.dimension) {
                NoSlimesCreepyEvents.LOGGER.warn("getPuppetEntity called with mismatching level dimension! Expected {}, got {}", (Object)this.dimension.m_135782_(), (Object)level.m_46472_().m_135782_());
                return null;
            }
            Entity entity = level.m_8791_(this.puppetEntityUUID);
            return entity instanceof Vindicator && (v = (Vindicator)entity).m_6084_() && this.puppetEntityInitialized ? v : null;
        }
    }
}

