/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.noslimes.noslimes_creepy_events.EventCaller;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="noslimes_creepy_events", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG_LOGS = BUILDER.comment("Whether to log debug messages to the console").define("enableDebugLogs", false);
    private static final ForgeConfigSpec.IntValue RANDOM_INTERVAL_MIN = BUILDER.comment("Minimum value for the random interval (in ticks)").defineInRange("randomIntervalMin", 300, 0, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue RANDOM_INTERVAL_MAX = BUILDER.comment("Maximum value for the random interval (in ticks)").defineInRange("randomIntervalMax", 1200, 1, Integer.MAX_VALUE);
    private static final ForgeConfigSpec.IntValue RANDOM_CHANCE = BUILDER.comment("The chance for an event to fire each interval (0-100)").defineInRange("randomChance", 75, 0, 100);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MODULE_CONFIG_LIST = BUILDER.comment("List of module configs in the format: name,enabled,weight").defineListAllowEmpty(List.of("moduleConfigs"), EventCaller::getDefaultModuleConfigStrings, Config::validateModuleConfig);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_ALLOW_LIST = BUILDER.comment("List of entity resource locations to spawn (e.g. 'minecraft:arrow')").defineListAllowEmpty(List.of("allowedEntities"), () -> List.of("minecraft:arrow", "minecraft:salmon", "minecraft:bat", "minecraft:silverfish"), Config::validateEntityName);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> DROP_DISALLOW_LIST = BUILDER.comment("List of dimensions to disallow from dropping items (e.g. 'minecraft:nether')").defineListAllowEmpty(List.of("disallowedDropDimensions"), () -> List.of("minecraft:the_end"), Config::validateDimensionName);
    private static final ForgeConfigSpec.IntValue MIN_DROP_PERCENTAGE = BUILDER.comment("Minimum percentage of inventory that will be dropped").defineInRange("minDropPercentage", 5, 0, 100);
    private static final ForgeConfigSpec.IntValue MAX_DROP_PERCENTAGE = BUILDER.comment("Maximum percentage of inventory that will be dropped").defineInRange("maxDropPercentage", 10, 0, 100);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static final Map<String, ModuleConfigEntry> moduleConfigs = new HashMap<String, ModuleConfigEntry>();
    public static boolean enableDebugLogs;
    public static int randomIntervalMin;
    public static int randomIntervalMax;
    public static int randomChance;
    public static Set<EntityType<?>> allowedEntities;
    public static Set<ResourceKey<Level>> disallowedDropDimensions;
    public static int minDropPercentage;
    public static int maxDropPercentage;

    private static boolean validateEntityName(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String name = (String)obj;
        try {
            ResourceLocation res = new ResourceLocation(name);
            return ForgeRegistries.ENTITY_TYPES.containsKey(res);
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.warn("Invalid entity name format in config: {}", (Object)name);
            return false;
        }
    }

    private static boolean validateDimensionName(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String name = (String)obj;
        try {
            new ResourceLocation(name);
            return true;
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.warn("Invalid dimension name format in config: '{}'", (Object)name);
            return false;
        }
    }

    private static boolean validateModuleConfig(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String s = (String)obj;
        return ModuleConfigEntry.parse(s) != null;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals("noslimes_creepy_events")) {
            return;
        }
        if (event.getConfig().getSpec() != SPEC) {
            return;
        }
        NoSlimesCreepyEvents.LOGGER.info("Loading config...");
        Config.loadConfigValues();
        NoSlimesCreepyEvents.logInfo("Loaded {} config for mod {}", event.getConfig().getType(), "noslimes_creepy_events");
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (!event.getConfig().getSpec().equals(SPEC)) {
            return;
        }
        Config.loadConfigValues();
        NoSlimesCreepyEvents.logInfo("Reloaded {} config for mod {}", event.getConfig().getType(), "noslimes_creepy_events");
    }

    private static void loadConfigValues() {
        enableDebugLogs = (Boolean)ENABLE_DEBUG_LOGS.get();
        randomIntervalMin = (Integer)RANDOM_INTERVAL_MIN.get();
        randomIntervalMax = (Integer)RANDOM_INTERVAL_MAX.get();
        randomChance = (Integer)RANDOM_CHANCE.get();
        moduleConfigs.clear();
        for (String entry : (List)MODULE_CONFIG_LIST.get()) {
            ModuleConfigEntry parsed = ModuleConfigEntry.parse(entry);
            if (parsed != null) {
                moduleConfigs.put(parsed.name, parsed);
                NoSlimesCreepyEvents.LOGGER.warn("{} : {}", (Object)parsed.name, (Object)parsed.enabled);
                continue;
            }
            NoSlimesCreepyEvents.LOGGER.warn("Invalid module config entry: '{}'", (Object)entry);
        }
        NoSlimesCreepyEvents.logInfo("Loaded {} module configs: {}", moduleConfigs.size(), moduleConfigs.keySet());
        NoSlimesCreepyEvents.logInfo("Loaded Config - Interval: [{}, {}], Chance: {}", randomIntervalMin, randomIntervalMax, randomChance);
        NoSlimesCreepyEvents.logInfo("Debug Logs Enabled: {}", enableDebugLogs);
        minDropPercentage = (Integer)MIN_DROP_PERCENTAGE.get();
        maxDropPercentage = (Integer)MAX_DROP_PERCENTAGE.get();
        try {
            allowedEntities = ((List)ENTITY_ALLOW_LIST.get()).stream().map(idString -> {
                try {
                    return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(idString));
                }
                catch (Exception e) {
                    NoSlimesCreepyEvents.LOGGER.error("Failed to parse entity resource location from config: {}", idString, (Object)e);
                    return null;
                }
            }).filter(type -> type != null && type != EntityType.f_20532_).collect(Collectors.toSet());
            Object[] objectArray = new Object[1];
            objectArray[0] = allowedEntities.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).map(ResourceLocation::toString).collect(Collectors.joining(", "));
            NoSlimesCreepyEvents.logInfo("Loaded Config - Allowed Entities: {}", objectArray);
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.error("Failed to load allowedEntities from config", (Throwable)e);
            allowedEntities = new HashSet();
        }
        try {
            List dimStrings = (List)DROP_DISALLOW_LIST.get();
            disallowedDropDimensions = dimStrings.stream().map(idString -> {
                try {
                    ResourceLocation rl = new ResourceLocation(idString);
                    return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                }
                catch (Exception e) {
                    NoSlimesCreepyEvents.LOGGER.error("Failed to parse dimension resource location from config: {}", idString, (Object)e);
                    return null;
                }
            }).filter(key -> key != null).collect(Collectors.toSet());
            NoSlimesCreepyEvents.logInfo("Loaded Config - Disallowed Drop Dimensions: {}", disallowedDropDimensions.stream().map(ResourceKey::m_135782_).map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.LOGGER.error("Failed to load disallowedDropDimensions from config", (Throwable)e);
            disallowedDropDimensions = new HashSet<ResourceKey<Level>>();
        }
        if (randomIntervalMin >= randomIntervalMax) {
            NoSlimesCreepyEvents.LOGGER.warn("Config validation failed: randomIntervalMin ({}) must be less than randomIntervalMax ({}). Using defaults for now. Check your config file!", (Object)randomIntervalMin, (Object)randomIntervalMax);
            randomIntervalMin = (Integer)RANDOM_INTERVAL_MIN.getDefault();
            randomIntervalMax = (Integer)RANDOM_INTERVAL_MAX.getDefault();
        }
        if (minDropPercentage > maxDropPercentage) {
            NoSlimesCreepyEvents.LOGGER.warn("Config validation failed: minDropPercentage ({}) must be less or equal to maxDropPercentage ({}). Using defaults for now. Check your config file!", (Object)minDropPercentage, (Object)maxDropPercentage);
            minDropPercentage = (Integer)MIN_DROP_PERCENTAGE.getDefault();
            maxDropPercentage = (Integer)MAX_DROP_PERCENTAGE.getDefault();
        }
    }

    public static boolean setRandomInterval(int min, int max) {
        if (min < 0 || max <= 0 || min >= max) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to set invalid interval: [{}, {}]", (Object)min, (Object)max);
            return false;
        }
        RANDOM_INTERVAL_MIN.set((Object)min);
        RANDOM_INTERVAL_MAX.set((Object)max);
        randomIntervalMin = min;
        randomIntervalMax = max;
        NoSlimesCreepyEvents.logInfo("Set interval to [{}, {}]", min, max);
        SPEC.save();
        return true;
    }

    public static boolean setRandomChance(int chance) {
        if ((double)chance < 0.0 || (double)chance > 100.0) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to set invalid chance: {}", (Object)chance);
            return false;
        }
        RANDOM_CHANCE.set((Object)chance);
        randomChance = chance;
        NoSlimesCreepyEvents.logInfo("Set chance to {}", chance);
        SPEC.save();
        return true;
    }

    static {
        allowedEntities = new HashSet();
        disallowedDropDimensions = new HashSet<ResourceKey<Level>>();
    }

    public static class ModuleConfigEntry {
        public final String name;
        public final boolean enabled;
        public final int weight;

        public ModuleConfigEntry(String name, boolean enabled, int weight) {
            this.name = name;
            this.enabled = enabled;
            this.weight = weight;
        }

        public static ModuleConfigEntry parse(String configString) {
            int weight;
            String[] parts = configString.split(",");
            if (parts.length != 3) {
                return null;
            }
            String name = parts[0].trim();
            boolean enabled = Boolean.parseBoolean(parts[1].trim());
            try {
                weight = Integer.parseInt(parts[2].trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
            return new ModuleConfigEntry(name, enabled, weight);
        }

        public String toString() {
            return this.name + "," + this.enabled + "," + this.weight;
        }
    }
}

