/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import com.noslimes.noslimes_creepy_events.util.MobHuntHandler;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;

public class PassiveMobsHuntingModule
extends EventModule {
    public static final int HUNTING_DURATION_TICKS = 200;
    public static final List<SoundEvent> SOUNDS_LIST = List.of(SoundEvents.f_11830_, SoundEvents.f_12341_, SoundEvents.f_11750_);

    @Override
    public boolean run(MinecraftServer server, ServerPlayer player) {
        AABB searchArea;
        if (server == null) {
            return false;
        }
        if (player == null && (player = this.getRandomPlayer(server)) == null) {
            return false;
        }
        ServerPlayer targetPlayer = player;
        ServerLevel level = targetPlayer.m_9236_();
        List potentialHunters = level.m_6443_(Mob.class, searchArea = new AABB(targetPlayer.m_20183_()).m_82400_(20.0), mob -> !mob.m_213877_() && mob.m_142582_((Entity)targetPlayer) && !MobHuntHandler.isHunting(mob) && mob.m_20280_((Entity)targetPlayer) > 1.0 && !(mob instanceof Villager) && !mob.m_7307_((Entity)targetPlayer));
        if (potentialHunters.isEmpty()) {
            NoSlimesCreepyEvents.logInfo("HuntEvent: No suitable mobs found to hunt {}.", targetPlayer.m_7755_().getString());
            return false;
        }
        int maxHunters = 10;
        int huntersToStart = Math.min(maxHunters, potentialHunters.size());
        int startedCount = 0;
        for (int i = 0; i < huntersToStart; ++i) {
            Mob hunter = (Mob)potentialHunters.get(i);
            SoundEvent selectedSound = SOUNDS_LIST.get(this.random.nextInt(SOUNDS_LIST.size()));
            level.m_6263_(null, hunter.m_20185_(), hunter.m_20186_(), hunter.m_20189_(), selectedSound, SoundSource.HOSTILE, 1.4f + this.random.nextFloat(), 0.3f + this.random.nextFloat() * 0.4f);
            boolean started = MobHuntHandler.startHunt(hunter, (LivingEntity)targetPlayer, 200);
            if (!started) continue;
            ++startedCount;
        }
        if (startedCount > 0) {
            NoSlimesCreepyEvents.logInfo("HuntEvent: Started {} mobs hunting {}.", startedCount, targetPlayer.m_7755_().getString());
            return true;
        }
        NoSlimesCreepyEvents.logInfo("HuntEvent: Failed to start hunt for any selected mobs (perhaps they became invalid or started hunting between checks?).", new Object[0]);
        return false;
    }
}

