/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.util;

import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class TickScheduler {
    private static final TickScheduler INSTANCE = new TickScheduler();
    private final ConcurrentLinkedQueue<ScheduledTask> taskQueue = new ConcurrentLinkedQueue();
    private long currentTick = 0L;

    private TickScheduler() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        NoSlimesCreepyEvents.logInfo("TickScheduler registered.", new Object[0]);
    }

    public static TickScheduler getInstance() {
        return INSTANCE;
    }

    public void schedule(int delayTicks, Runnable task) {
        if (delayTicks <= 0 || task == null) {
            System.err.println("Invalid schedule request: delay=" + delayTicks + ", task=" + String.valueOf(task));
            return;
        }
        long target = this.currentTick + (long)delayTicks;
        this.taskQueue.offer(new ScheduledTask(target, task));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            ++this.currentTick;
            Iterator<ScheduledTask> iterator = this.taskQueue.iterator();
            while (iterator.hasNext()) {
                ScheduledTask scheduledTask = iterator.next();
                if (scheduledTask.targetTick > this.currentTick) continue;
                try {
                    scheduledTask.task.run();
                }
                catch (Exception e) {
                    System.err.println("Error executing scheduled task:");
                    e.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    private static class ScheduledTask {
        final long targetTick;
        final Runnable task;

        ScheduledTask(long targetTick, Runnable task) {
            this.targetTick = targetTick;
            this.task = Objects.requireNonNull(task, "Scheduled task cannot be null");
        }
    }
}

