/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events;

import com.noslimes.noslimes_creepy_events.Config;
import com.noslimes.noslimes_creepy_events.EventModules.EntitySpawnerModule;
import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.EventModules.InventoryDropModule;
import com.noslimes.noslimes_creepy_events.EventModules.InventoryScrambleModule;
import com.noslimes.noslimes_creepy_events.EventModules.MobStareModule;
import com.noslimes.noslimes_creepy_events.EventModules.PassiveMobsHuntingModule;
import com.noslimes.noslimes_creepy_events.EventModules.PlayerSpinnerModule;
import com.noslimes.noslimes_creepy_events.EventModules.PlayerThreatenModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomEffectModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomSoundPlayerModule;
import com.noslimes.noslimes_creepy_events.EventModules.RandomTalkerModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventCaller {
    private final Map<EventModule, Integer> modules;
    private final Set<EventModule> availableModules = new HashSet<EventModule>();
    private final Random random = new Random();
    private int availableModulesWeight;
    private int ticksRemaining = 0;
    private EventModule lastExecutedModule = null;
    private boolean pauseExecution = false;
    private MinecraftServer server;
    private static EventCaller instance;

    private EventCaller() {
        HashMap<EventModule, Integer> builder = new HashMap<EventModule, Integer>();
        builder.put(new InventoryDropModule(), 3);
        builder.put(new InventoryScrambleModule(), 5);
        builder.put(new RandomTalkerModule(), 11);
        builder.put(new PassiveMobsHuntingModule(), 11);
        builder.put(new RandomEffectModule(), 12);
        builder.put(new PlayerSpinnerModule(), 12);
        builder.put(new PlayerThreatenModule(), 6);
        builder.put(new MobStareModule(), 13);
        builder.put(new EntitySpawnerModule(), 16);
        builder.put(new RandomSoundPlayerModule(), 17);
        this.modules = Collections.unmodifiableMap(builder);
        this.availableModules.clear();
        this.availableModules.addAll(builder.keySet());
    }

    public static void register() {
        if (instance == null) {
            instance = new EventCaller();
            MinecraftForge.EVENT_BUS.register((Object)instance);
            NoSlimesCreepyEvents.logInfo("EventCaller registered successfully.", new Object[0]);
        }
    }

    public static EventCaller getInstance() {
        return instance;
    }

    public void setupModules() {
        this.disableBasedOnConfig(Config.allowEntitySpawning, EntitySpawnerModule.class);
        this.disableBasedOnConfig(Config.allowMobTalking, RandomTalkerModule.class);
        this.disableBasedOnConfig(Config.allowMobTalking, PassiveMobsHuntingModule.class);
        this.disableBasedOnConfig(Config.allowSoundPlaying, RandomSoundPlayerModule.class);
        this.disableBasedOnConfig(Config.allowPotionEffects, RandomEffectModule.class);
        this.disableBasedOnConfig(Config.allowSpinningPlayer, PlayerSpinnerModule.class);
        this.disableBasedOnConfig(Config.allowDroppingItems, InventoryDropModule.class);
        this.disableBasedOnConfig(Config.allowPlayerMessages, PlayerThreatenModule.class);
        this.disableBasedOnConfig(Config.allowInventoryScramble, InventoryScrambleModule.class);
        this.disableBasedOnConfig(Config.allowAnimalsHunting, MobStareModule.class);
        this.recalculateAvailableWeight();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
        if (this.server.m_7416_() < 1) {
            this.setPauseExecution(true, "No players online");
        }
    }

    @SubscribeEvent
    public void onPlayerLeaving(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.server.m_7416_() < 1) {
            this.setPauseExecution(true, "No players online");
        }
    }

    @SubscribeEvent
    public void onPlayerJoining(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.server.m_7416_() > 0 && this.pauseExecution) {
            this.setPauseExecution(false, "There are now players online");
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.pauseExecution) {
            return;
        }
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return;
        }
        if (this.modules.isEmpty()) {
            NoSlimesCreepyEvents.LOGGER.warn("Modules are empty. Cannot execute commands.");
            this.resetInterval();
            return;
        }
        int tries = 0;
        boolean success = false;
        while (tries < 10 && !success) {
            success = this.runRandomModule(this.server);
            if (success) continue;
            NoSlimesCreepyEvents.logInfo("Retrying... Attempt {} of 10", ++tries);
        }
        if (!success) {
            NoSlimesCreepyEvents.LOGGER.warn("Failed to execute a module after 10 attempts.");
        }
        this.resetInterval();
    }

    private boolean runRandomModule(MinecraftServer server) {
        if (!this.executionRoll()) {
            return true;
        }
        EventModule selected = this.selectModuleBasedOnWeight();
        if (selected == null) {
            NoSlimesCreepyEvents.LOGGER.error("No valid module selected. Skipping execution.");
            return true;
        }
        this.lastExecutedModule = selected;
        return this.runSelectedModule(server, selected);
    }

    private boolean runSelectedModule(MinecraftServer server, @NotNull EventModule module) {
        NoSlimesCreepyEvents.logInfo("Selected module: {}", module.getClass().getSimpleName());
        try {
            module.run(server);
            NoSlimesCreepyEvents.logInfo("Executed module: {}", module.getClass().getSimpleName());
            return true;
        }
        catch (Exception e) {
            NoSlimesCreepyEvents.logInfo("Error executing module: {}", module.getClass().getSimpleName(), e);
            return false;
        }
    }

    private void resetInterval() {
        this.ticksRemaining = Config.randomIntervalMin + this.random.nextInt(Config.randomIntervalMax - Config.randomIntervalMin + 1);
        NoSlimesCreepyEvents.logInfo("Next interval set to: {} ticks.", this.ticksRemaining);
    }

    private EventModule selectModuleBasedOnWeight() {
        EventModule candidate;
        if (this.availableModules.isEmpty()) {
            NoSlimesCreepyEvents.LOGGER.warn("No available modules to select from.");
            return null;
        }
        block0: do {
            int randomWeight = this.random.nextInt(this.availableModulesWeight);
            int cumulativeWeight = 0;
            candidate = null;
            for (EventModule module : this.availableModules) {
                if (randomWeight >= (cumulativeWeight += this.modules.get(module).intValue())) continue;
                candidate = module;
                continue block0;
            }
        } while (candidate == this.lastExecutedModule && this.availableModules.size() > 1);
        return candidate;
    }

    private boolean executionRoll() {
        int roll = this.random.nextInt(100);
        if (roll < Config.randomChance) {
            NoSlimesCreepyEvents.logInfo("Passed chance check: roll ({}) < chance ({}%)", roll, Config.randomChance);
            return true;
        }
        NoSlimesCreepyEvents.logInfo("Skipped execution: roll ({}) >= chance ({}%)", roll, Config.randomChance);
        return false;
    }

    public void disableModule(EventModule module) {
        if (!this.availableModules.contains(module)) {
            NoSlimesCreepyEvents.logInfo("Module {} is already disabled.", module.getClass().getSimpleName());
            return;
        }
        this.availableModules.remove(module);
        NoSlimesCreepyEvents.logInfo("Module {} disabled.", module.getClass().getSimpleName());
        this.recalculateAvailableWeight();
    }

    public void enableModule(EventModule module) {
        if (this.availableModules.contains(module)) {
            NoSlimesCreepyEvents.logInfo("Module {} is already enabled.", module.getClass().getSimpleName());
            return;
        }
        this.availableModules.add(module);
        NoSlimesCreepyEvents.logInfo("Module {} enabled.", module.getClass().getSimpleName());
        this.recalculateAvailableWeight();
    }

    public <T extends EventModule> T getModule(Class<T> moduleClass) {
        for (EventModule module : this.modules.keySet()) {
            if (!module.getClass().equals(moduleClass)) continue;
            return (T)((EventModule)moduleClass.cast(module));
        }
        return null;
    }

    public Set<EventModule> getModules() {
        return this.modules.keySet();
    }

    public void skipInterval() {
        this.ticksRemaining = 0;
    }

    private <T extends EventModule> void disableBasedOnConfig(boolean configValue, Class<T> moduleClass) {
        T module = this.getModule(moduleClass);
        if (module != null) {
            if (configValue) {
                this.enableModule((EventModule)module);
            } else {
                this.disableModule((EventModule)module);
            }
        } else {
            NoSlimesCreepyEvents.LOGGER.warn("Module class {} not found.", (Object)moduleClass.getSimpleName());
        }
    }

    public void setPauseExecution(boolean pauseExecution, String message) {
        this.pauseExecution = pauseExecution;
        String status = String.valueOf(pauseExecution).toUpperCase(Locale.ROOT);
        NoSlimesCreepyEvents.LOGGER.info("Pause state changed to {}: {}", (Object)status, (Object)message);
    }

    public boolean isPauseExecution() {
        return this.pauseExecution;
    }

    private void recalculateAvailableWeight() {
        this.availableModulesWeight = 0;
        if (this.availableModules.isEmpty()) {
            NoSlimesCreepyEvents.logInfo("No available modules. Weight is 0.", new Object[0]);
            return;
        }
        for (EventModule module : this.availableModules) {
            int weight = this.modules.get(module);
            this.availableModulesWeight += weight;
        }
        NoSlimesCreepyEvents.logInfo("Recalculated weight. Total weight: {}", this.availableModulesWeight);
    }
}

