/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.Config;
import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class InventoryDropModule
extends EventModule {
    private final Random random = new Random();
    private static final SoundEvent DROP_SOUND = SoundEvents.f_11850_;
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 1.8f;

    @Override
    public boolean run(MinecraftServer server, ServerPlayer player) {
        if (server == null) {
            return false;
        }
        if (player == null && (player = this.getRandomPlayer(server)) == null) {
            return false;
        }
        ServerPlayer targetPlayer = player;
        Level playerLevel = targetPlayer.f_19853_;
        ResourceKey playerDimensionKey = playerLevel.m_46472_();
        if (Config.disallowedDropDimensions.contains(playerDimensionKey)) {
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: Player {} is in disallowed dimension {}. Skipping.", targetPlayer.m_7755_().getString(), playerDimensionKey.m_135782_());
            return false;
        }
        Inventory inventory = targetPlayer.m_150109_();
        ArrayList<Integer> potentialSlotsToDrop = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            potentialSlotsToDrop.add(i);
        }
        if (potentialSlotsToDrop.isEmpty()) {
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: Player {} has an empty main inventory.", targetPlayer.m_7755_().getString());
            return false;
        }
        double actualPercentage = (double)Config.minDropPercentage + this.random.nextDouble() * (double)(Config.maxDropPercentage - Config.minDropPercentage);
        int numberOfItemsToDrop = (int)Math.ceil((double)potentialSlotsToDrop.size() * (actualPercentage / 100.0));
        if ((numberOfItemsToDrop = Math.min(numberOfItemsToDrop, potentialSlotsToDrop.size())) <= 0) {
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: Calculated 0 items to drop for {}.", targetPlayer.m_7755_().getString());
            return false;
        }
        NoSlimesCreepyEvents.logInfo("InventoryDropModule: Making {} drop {} items ({}% of {} occupied slots).", targetPlayer.m_7755_().getString(), numberOfItemsToDrop, String.format("%.1f", actualPercentage), potentialSlotsToDrop.size());
        Collections.shuffle(potentialSlotsToDrop, this.random);
        List slotsToDrop = potentialSlotsToDrop.subList(0, numberOfItemsToDrop);
        int itemsDropped = 0;
        Iterator iterator = slotsToDrop.iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            ItemStack stackToDrop = inventory.m_8020_(slotIndex);
            if (stackToDrop.m_41619_()) continue;
            inventory.m_6836_(slotIndex, ItemStack.f_41583_);
            targetPlayer.m_7197_(stackToDrop, true, true);
            ++itemsDropped;
        }
        if (itemsDropped > 0) {
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: Successfully dropped {} items for {}.", itemsDropped, targetPlayer.m_7755_().getString());
            targetPlayer.f_19853_.m_6263_(null, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), DROP_SOUND, SoundSource.PLAYERS, 1.0f, 0.7f + this.random.nextFloat() * 0.4f);
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: Played sound {} for {}.", DROP_SOUND.m_11660_(), targetPlayer.m_7755_().getString());
        } else {
            NoSlimesCreepyEvents.logInfo("InventoryDropModule: No items were actually dropped for {}.", targetPlayer.m_7755_().getString());
        }
        return true;
    }
}

