/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventoryScrambleModule
extends EventModule {
    private static final SoundEvent DROP_SOUND = SoundEvents.f_11803_;
    private static final float SOUND_VOLUME = 1.0f;
    private static final float SOUND_PITCH = 0.6f;
    private static final int MIN_SLOTS = 2;
    private static final int MAX_SLOTS = 4;
    private final Random random = new Random();

    @Override
    public boolean run(MinecraftServer server, ServerPlayer player) {
        if (server == null) {
            return false;
        }
        if (player == null && (player = this.getRandomPlayer(server)) == null) {
            return false;
        }
        ServerPlayer targetPlayer = player;
        Inventory inventory = targetPlayer.m_150109_();
        List<ItemStack> inventoryBackup = inventory.f_35974_.stream().map(ItemStack::m_41777_).toList();
        try {
            List filledSlots = IntStream.range(0, inventory.f_35974_.size()).filter(i -> !((ItemStack)inventory.f_35974_.get(i)).m_41619_()).boxed().collect(Collectors.toList());
            if (filledSlots.size() < 2) {
                NoSlimesCreepyEvents.LOGGER.warn("Inventory scramble aborted: not enough items to shuffle for player {}", (Object)targetPlayer.m_5446_().getString());
                return false;
            }
            Collections.shuffle(filledSlots);
            int slotsToShuffle = Math.min(4, filledSlots.size());
            List slotsToScramble = filledSlots.subList(0, slotsToShuffle);
            Collections.shuffle(slotsToScramble);
            ItemStack[] newContents = (ItemStack[])inventory.f_35974_.toArray((Object[])new ItemStack[0]);
            for (int idx = 0; idx < slotsToScramble.size(); ++idx) {
                int fromSlot = (Integer)slotsToScramble.get(idx);
                int toSlot = (Integer)slotsToScramble.get((idx + 1) % slotsToScramble.size());
                newContents[toSlot] = inventoryBackup.get(fromSlot).m_41777_();
            }
            for (int i2 = 0; i2 < newContents.length; ++i2) {
                inventory.f_35974_.set(i2, (Object)newContents[i2]);
            }
            targetPlayer.f_36095_.m_38946_();
            NoSlimesCreepyEvents.LOGGER.info("Successfully shuffled player \"{}\"'s inventory", (Object)targetPlayer.m_5446_().getString());
        }
        catch (Exception e) {
            for (int i3 = 0; i3 < inventoryBackup.size(); ++i3) {
                inventory.f_35974_.set(i3, (Object)inventoryBackup.get(i3));
            }
            targetPlayer.f_36095_.m_38946_();
            NoSlimesCreepyEvents.LOGGER.error("Inventory scramble failed for player {}", (Object)targetPlayer.m_5446_().getString(), (Object)e);
            return false;
        }
        targetPlayer.f_19853_.m_6263_(null, targetPlayer.m_20185_(), targetPlayer.m_20186_(), targetPlayer.m_20189_(), DROP_SOUND, SoundSource.PLAYERS, 1.0f, 0.6f + this.random.nextFloat() * 0.4f);
        return true;
    }
}

