/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.EventModules;

import com.noslimes.noslimes_creepy_events.EventModules.EventModule;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;

public class RandomEffectModule
extends EventModule {
    private static final Random random = new Random();
    private static final List<MobEffect> POTENTIAL_EFFECTS = Arrays.asList(MobEffects.f_19614_, MobEffects.f_19610_, MobEffects.f_19613_, MobEffects.f_19599_, MobEffects.f_19620_, MobEffects.f_19604_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19619_, MobEffects.f_19615_, MobEffects.f_19596_, MobEffects.f_19603_);
    private static final int MIN_DURATION_SECONDS = 5;
    private static final int MAX_DURATION_SECONDS = 15;
    private static final int MAX_AMPLIFIER = 1;
    private static final int LEVITATION_MAX_DURATION_SECONDS = 1;
    private static final int LEVITATION_AMPLIFIER = 3;
    private static final List<String> FLAVOR_MESSAGES = Arrays.asList("You feel a sudden chill...", "A wave of dizziness washes over you.", "Something feels... off.", "Your senses momentarily betray you.", "An unseen force meddles with you.");

    @Override
    public boolean run(MinecraftServer server, ServerPlayer player) {
        int amplifier;
        int durationTicks;
        if (server == null) {
            return false;
        }
        if (player == null && (player = this.getRandomPlayer(server)) == null) {
            return false;
        }
        ServerPlayer targetPlayer = player;
        MobEffect chosenEffectType = POTENTIAL_EFFECTS.get(random.nextInt(POTENTIAL_EFFECTS.size()));
        if (chosenEffectType.equals(MobEffects.f_19620_)) {
            durationTicks = random.nextInt(1) + 10;
            amplifier = 3;
        } else {
            int durationSeconds = random.nextInt(11) + 5;
            durationTicks = durationSeconds * 20;
            amplifier = random.nextInt(2);
            if (chosenEffectType.equals(MobEffects.f_19615_)) {
                amplifier = Math.min(amplifier, 0);
                durationTicks = Math.min(durationTicks, 40);
            }
        }
        durationTicks = Math.max(1, durationTicks);
        MobEffectInstance effectInstance = new MobEffectInstance(chosenEffectType, durationTicks, amplifier, false, true, true);
        String message = FLAVOR_MESSAGES.get(random.nextInt(FLAVOR_MESSAGES.size()));
        targetPlayer.m_240418_((Component)Component.m_237113_((String)message), true);
        targetPlayer.m_7292_(effectInstance);
        NoSlimesCreepyEvents.logInfo("[CreepyEvents] Applied effect " + String.valueOf(chosenEffectType.m_19482_()) + " Lvl " + (amplifier + 1) + " for " + (double)durationTicks / 20.0 + "s to " + targetPlayer.m_7755_().getString(), new Object[0]);
        return true;
    }
}

