/*
 * Decompiled with CFR 0.152.
 */
package com.noslimes.noslimes_creepy_events.util;

import com.google.common.collect.Maps;
import com.noslimes.noslimes_creepy_events.NoSlimesCreepyEvents;
import java.lang.ref.WeakReference;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class MobHuntHandler {
    private static final ConcurrentMap<UUID, HuntData> huntingMobs = Maps.newConcurrentMap();
    private static long currentServerTick = 0L;
    private static boolean isListenerRegistered = false;
    private static final double ATTACK_RANGE_SQ = 9.0;
    private static final float ATTACK_DAMAGE = 3.0f;
    private static final int ATTACK_COOLDOWN_TICKS = 20;
    private static final double MOVEMENT_SPEED_MULTIPLIER = 1.1;

    private static void registerHandler() {
        if (!isListenerRegistered) {
            MinecraftForge.EVENT_BUS.register(MobHuntHandler.class);
            NoSlimesCreepyEvents.logInfo("MobHuntHandler registered for server ticks.", new Object[0]);
            isListenerRegistered = true;
        }
    }

    public static boolean startHunt(Mob hunter, LivingEntity target, int durationTicks) {
        if (durationTicks <= 0 || hunter == null || !hunter.m_6084_() || hunter.f_19853_.m_5776_() || target == null || !target.m_6084_()) {
            NoSlimesCreepyEvents.LOGGER.warn("Attempted to start hunt with invalid parameters: hunter={}, target={}, duration={}", new Object[]{hunter, target, durationTicks});
            return false;
        }
        if (huntingMobs.containsKey(hunter.m_20148_())) {
            NoSlimesCreepyEvents.logInfo("Mob {} is already hunting, ignoring new request.", hunter.m_20148_());
            return false;
        }
        LivingEntity originalTarget = hunter.m_5448_();
        long endTick = currentServerTick + (long)durationTicks;
        HuntData data = new HuntData(hunter, target, originalTarget, endTick);
        hunter.m_6710_(target);
        huntingMobs.put(hunter.m_20148_(), data);
        NoSlimesCreepyEvents.logInfo("Started hunt: Mob {} -> Target {} for {} ticks (until tick {})", hunter.m_20148_(), target.m_20148_(), durationTicks, endTick);
        MobHuntHandler.registerHandler();
        return true;
    }

    public static boolean stopHunt(Mob hunter) {
        if (hunter == null) {
            return false;
        }
        return MobHuntHandler.stopHunt(hunter.m_20148_());
    }

    public static boolean stopHunt(UUID hunterUUID) {
        HuntData data = (HuntData)huntingMobs.remove(hunterUUID);
        if (data != null) {
            NoSlimesCreepyEvents.logInfo("Stopping hunt for mob {}", hunterUUID);
            MobHuntHandler.restoreMobState(data.getHunter(), data);
            return true;
        }
        return false;
    }

    public static boolean isHunting(Mob hunter) {
        return hunter != null && huntingMobs.containsKey(hunter.m_20148_());
    }

    private static void restoreMobState(@Nullable Mob hunter, HuntData data) {
        if (hunter == null || !hunter.m_6084_() || hunter.m_213877_()) {
            NoSlimesCreepyEvents.logInfo("Cannot restore state for mob {} (invalid or removed)", data.mobUUID);
            huntingMobs.remove(data.mobUUID);
            return;
        }
        NoSlimesCreepyEvents.logInfo("Restoring state for mob {} after hunting.", hunter.m_20148_());
        LivingEntity originalTarget = data.originalTarget;
        if (originalTarget != null && originalTarget.m_6084_() && !originalTarget.m_213877_()) {
            if (TargetingConditions.f_26872_.m_26885_((LivingEntity)hunter, originalTarget)) {
                hunter.m_6710_(originalTarget);
            } else {
                hunter.m_6710_(null);
            }
        } else {
            hunter.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (!isListenerRegistered || event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ++currentServerTick;
        if (huntingMobs.isEmpty()) {
            return;
        }
        huntingMobs.entrySet().removeIf(entry -> {
            PathNavigation navigator;
            double distanceSq;
            UUID mobUUID = (UUID)entry.getKey();
            HuntData data = (HuntData)entry.getValue();
            Mob hunter = data.getHunter();
            LivingEntity target = data.getTarget();
            boolean remove = false;
            String reason = "";
            if (hunter == null || !hunter.m_6084_() || hunter.m_213877_()) {
                remove = true;
                reason = "Hunter mob invalid/removed";
            } else if (target == null || !target.m_6084_() || target.m_213877_() || target.f_19853_ != hunter.f_19853_) {
                remove = true;
                reason = "Target entity invalid/removed/wrong level";
            } else if (currentServerTick >= data.endTick) {
                remove = true;
                reason = "Hunt duration ended";
            }
            if (remove) {
                NoSlimesCreepyEvents.logInfo("Stopping hunt for mob {}: {}", mobUUID, reason);
                MobHuntHandler.restoreMobState(hunter, data);
                return true;
            }
            if (hunter.m_5448_() != target) {
                hunter.m_6710_(target);
            }
            boolean inRange = (distanceSq = hunter.m_20280_((Entity)target)) <= 9.0;
            boolean cooldownReady = currentServerTick >= data.lastAttackTick + 20L;
            boolean hasLOS = hunter.m_142582_((Entity)target);
            if (inRange && cooldownReady && hasLOS) {
                NoSlimesCreepyEvents.logInfo("Mob {} attacking target {}!", mobUUID, target.m_20148_());
                hunter.m_6674_(InteractionHand.MAIN_HAND);
                DamageSource source = DamageSource.m_19370_((LivingEntity)hunter);
                target.m_6469_(source, 3.0f);
                data.lastAttackTick = currentServerTick;
                hunter.m_21573_().m_26573_();
            } else if (!inRange && ((navigator = hunter.m_21573_()).m_26571_() || navigator.m_26567_() == null || navigator.m_26567_().m_123331_((Vec3i)target.m_20183_()) > 4.0)) {
                navigator.m_5624_((Entity)target, 1.1);
            }
            return false;
        });
    }

    private static class HuntData {
        final UUID mobUUID;
        final WeakReference<Mob> hunterRef;
        final WeakReference<LivingEntity> targetRef;
        @Nullable
        final LivingEntity originalTarget;
        final long endTick;
        long lastAttackTick;

        HuntData(Mob hunter, LivingEntity target, @Nullable LivingEntity originalTarget, long endTick) {
            this.mobUUID = hunter.m_20148_();
            this.hunterRef = new WeakReference<Mob>(hunter);
            this.targetRef = new WeakReference<LivingEntity>(target);
            this.originalTarget = originalTarget;
            this.endTick = endTick;
            this.lastAttackTick = 0L;
        }

        @Nullable
        Mob getHunter() {
            return (Mob)this.hunterRef.get();
        }

        @Nullable
        LivingEntity getTarget() {
            return (LivingEntity)this.targetRef.get();
        }
    }
}

