/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.item.LeavesBucketItem;
import net.seface.somemoreblocks.tags.SMBBlockTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeafLitterBlock
extends TransparentBlock
implements BucketPickup {
    public static final MapCodec<LeafLitterBlock> CODEC = LeafLitterBlock.simpleCodec(LeafLitterBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private Item bucketItem;

    public LeafLitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends TransparentBlock> codec() {
        return CODEC;
    }

    public boolean skipRendering(BlockState state1, BlockState state2, Direction direction) {
        return state2.is((Block)this) || super.skipRendering(state1, state2, direction);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter block, BlockPos pos) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter block, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    protected BlockState updateShape(BlockState state1, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos1, BlockPos pos2) {
        return !state1.canSurvive((LevelReader)level, pos1) ? Blocks.AIR.defaultBlockState() : super.updateShape(state1, direction, state2, level, pos1, pos2);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)stateBelow.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP) || stateBelow.is(SMBBlockTags.LEAF_LITTERS_PLACEABLE);
    }

    @NotNull
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(level, pos, state);
        stack.set(((LeavesBucketItem)stack.getItem()).getBucketVolumeComponentType(), (Object)16);
        return stack;
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide()) {
            level.levelEvent(2001, pos, Block.getId((BlockState)state));
        }
        ItemStack stack = this.bucketItem.getDefaultInstance();
        stack.set(((LeavesBucketItem)stack.getItem()).getBucketVolumeComponentType(), (Object)1);
        return stack;
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    @Generated
    public void setBucketItem(Item bucketItem) {
        this.bucketItem = bucketItem;
    }

    @Generated
    public Item getBucketItem() {
        return this.bucketItem;
    }
}

