/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.platform.registry;

import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.seface.somemoreblocks.SomeMoreBlocks;
import net.seface.somemoreblocks.item.FuelBlockItem;
import net.seface.somemoreblocks.platform.registry.ForgeRegistryObject;
import net.seface.somemoreblocks.platform.registry.PlatformRegistry;
import net.seface.somemoreblocks.platform.registry.PlatformRegistryObject;

public class ForgePlatformRegistry
implements PlatformRegistry {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"somemoreblocks");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"somemoreblocks");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"somemoreblocks");
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"somemoreblocks");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"somemoreblocks");
    private static final Map<String, Integer> FUEL_BLOCK_ITEMS = Map.ofEntries(Map.entry("coal_bricks", 32000), Map.entry("cracked_coal_bricks", 19200), Map.entry("coal_pillar", 16000), Map.entry("cut_coal", Short.MAX_VALUE), Map.entry("cracked_cut_coal", 19800), Map.entry("clover", 100));

    @Override
    public PlatformRegistryObject<Block> registerBlock(String path, Supplier<Block> supplier, boolean registerBlockItem) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        RegistryObject instance = BLOCKS.register(path, supplier);
        if (registerBlockItem) {
            if (FUEL_BLOCK_ITEMS.containsKey(path)) {
                this.registerItem(path, () -> new FuelBlockItem((Block)instance.get(), new Item.Properties(), FUEL_BLOCK_ITEMS.get(path)));
            } else {
                this.registerItem(path, () -> new BlockItem((Block)instance.get(), new Item.Properties()));
            }
        }
        return new ForgeRegistryObject<Block>(identifier, instance);
    }

    @Override
    public PlatformRegistryObject<Item> registerItem(String path, Supplier<Item> supplier) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        RegistryObject instance = ITEMS.register(path, supplier);
        return new ForgeRegistryObject<Item>(identifier, instance);
    }

    @Override
    public <T> PlatformRegistryObject<DataComponentType<T>> registerDataComponent(String path, UnaryOperator<DataComponentType.Builder<T>> builder) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        RegistryObject instance = DATA_COMPONENT_TYPES.register(path, () -> ((DataComponentType.Builder)builder.apply(DataComponentType.builder())).build());
        return new ForgeRegistryObject<DataComponentType<T>>(identifier, instance);
    }

    @Override
    public <F extends Feature<? extends FeatureConfiguration>> PlatformRegistryObject<F> registerFeature(String path, Supplier<F> supplier) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        RegistryObject instance = FEATURES.register(path, supplier);
        return new ForgeRegistryObject(identifier, instance);
    }

    @Override
    public PlatformRegistryObject<CreativeModeTab> registerCreativeModeTab(String path, CreativeModeTab.Row row, int i, UnaryOperator<CreativeModeTab.Builder> builder) {
        ResourceLocation identifier = SomeMoreBlocks.id(path);
        RegistryObject instance = CREATIVE_MODE_TABS.register(path, () -> ((CreativeModeTab.Builder)builder.apply(CreativeModeTab.builder((CreativeModeTab.Row)row, (int)i))).build());
        return new ForgeRegistryObject<CreativeModeTab>(identifier, instance);
    }

    @Override
    public GameRules.Key<GameRules.BooleanValue> registerBooleanGameRule(String id, GameRules.Category category, boolean defaultValue) {
        return GameRules.register((String)id, (GameRules.Category)category, (GameRules.Type)GameRules.BooleanValue.create((boolean)defaultValue));
    }

    @Override
    public void setBlockRenderType(Block block, RenderType renderType) {
        if (renderType == RenderType.translucent()) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
            ItemBlockRenderTypes.TYPE_BY_BLOCK.put(block, renderType);
            return;
        }
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    public static void init(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        DATA_COMPONENT_TYPES.register(eventBus);
        FEATURES.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
    }
}

