/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.platform;

import java.util.ServiceLoader;
import lombok.Generated;
import net.seface.somemoreblocks.SomeMoreBlocks;
import net.seface.somemoreblocks.platform.PlatformHelper;
import net.seface.somemoreblocks.platform.registry.PlatformRegistry;

public class PlatformServices {
    public static final PlatformHelper HELPER = PlatformServices.tryToLoadService(PlatformHelper.class);
    public static final PlatformRegistry REGISTRY = HELPER.getRegistry();

    public static <T> T tryToLoadService(Class<T> clazz) {
        T service = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Error trying to load service for >> " + clazz.getName() + " <<"));
        SomeMoreBlocks.LOGGER.info("Loaded service: {}", service);
        return service;
    }

    public static enum Platforms {
        FABRIC(0, "Fabric"),
        FORGE(1, "Forge"),
        NEOFORGE(2, "NeoForge");

        private final int index;
        private final String name;

        private Platforms(int index, String name) {
            this.index = index;
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

