/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.seface.somemoreblocks.platform.PlatformServices;
import net.seface.somemoreblocks.registries.SMBBlocks;
import net.seface.somemoreblocks.registries.SMBCreativeTabs;
import net.seface.somemoreblocks.registries.SMBDataComponentTypes;
import net.seface.somemoreblocks.registries.SMBFeatures;
import net.seface.somemoreblocks.registries.SMBGameRules;
import net.seface.somemoreblocks.registries.SMBItems;
import net.seface.somemoreblocks.tags.SMBBlockTags;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SomeMoreBlocks {
    public static final String ID = "somemoreblocks";
    public static final String MOD_NAME = "Some More Blocks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Some More Blocks");

    public static void init() {
        SomeMoreBlocks.init(null, null);
    }

    public static void init(@Nullable Runnable beforeRegistries, @Nullable Runnable afterRegistries) {
        if (PlatformServices.HELPER.isModLoaded(ID)) {
            SomeMoreBlocks.printHeader();
        }
        if (beforeRegistries != null) {
            beforeRegistries.run();
        }
        SMBDataComponentTypes.init();
        SMBBlocks.init();
        SMBItems.init();
        SMBBlockTags.init();
        SMBFeatures.init();
        SMBCreativeTabs.init();
        SMBGameRules.init();
        if (afterRegistries != null) {
            afterRegistries.run();
        }
    }

    public static void initClient() {
        SomeMoreBlocks.registerBlockRenders();
        SomeMoreBlocks.registerModelPredicates();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> registry, String path) {
        return ResourceKey.create(registry, (ResourceLocation)SomeMoreBlocks.id(path));
    }

    public static <T> TagKey<T> tagKey(ResourceKey<Registry<T>> registryType, String path) {
        return TagKey.create(registryType, (ResourceLocation)SomeMoreBlocks.id(path));
    }

    private static void printHeader() {
        LOGGER.info("*****************************************************");
        LOGGER.info("*           Some More Blocks initialized!           *");
        LOGGER.info("*          https://sefacestudios.net/links          *");
        LOGGER.info("*****************************************************");
        LOGGER.info("  > Platform: " + PlatformServices.HELPER.getPlatformName());
        LOGGER.info("  > Environment: " + PlatformServices.HELPER.getEnvironment().getName());
        LOGGER.info("  > Version: " + PlatformServices.HELPER.getVersion());
        LOGGER.info("*****************************************************");
    }

    private static void registerBlockRenders() {
        RenderType cutout = RenderType.cutout();
        RenderType cutoutMipped = RenderType.cutoutMipped();
        RenderType translucent = RenderType.translucent();
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.AZALEA_LEAF_LITTER.get(), cutoutMipped);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BIG_LILY_PAD.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BIRCH_LEAF_LITTER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BLACK_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BLACK_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BLUE_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BLUE_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BROWN_MUSHROOM_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BROWN_MUSHROOM_COLONY_WALL.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BROWN_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.BROWN_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CATTAIL.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CLOVER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.NETHER_CLOVER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CRIMSON_FUNGUS_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CRIMSON_FUNGUS_COLONY_WALL.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CYAN_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.CYAN_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.DIAMOND_GRATE.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.DUNE_GRASS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.FLOWERING_AZALEA_LEAF_LITTER.get(), cutoutMipped);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.GRAY_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.GRAY_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.GREEN_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.GREEN_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.IRON_GRATE.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LARGE_SNOW_FERN.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LEAF_LITTER.get(), cutoutMipped);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIGHT_BLUE_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIGHT_BLUE_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIGHT_GRAY_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIGHT_GRAY_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIME_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LIME_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.LUMINOUS_FLOWER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.MAGENTA_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.MAGENTA_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.NETHERITE_GRATE.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.ORANGE_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.ORANGE_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.PINK_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.PINK_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.POTTED_LUMINOUS_FLOWER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.POTTED_SNOW_FERN.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.POTTED_TINY_CACTUS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.PURPLE_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.PURPLE_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.RED_MUSHROOM_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.RED_MUSHROOM_COLONY_WALL.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.RED_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.RED_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.REEDS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.SHORT_SNOW_GRASS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.SMALL_LILY_PADS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.SNOW_FERN.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.SPRUCE_LEAF_LITTER.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_BROWN_MUSHROOM_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_CACTUS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_CRIMSON_FUNGUS_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_DUNE_GRASS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_RED_MUSHROOM_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_SNOW_GRASS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TALL_WARPED_FUNGUS_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TILED_TINTED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.TINY_CACTUS.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.WARPED_FUNGUS_COLONY.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.WARPED_FUNGUS_COLONY_WALL.get(), cutout);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.WHITE_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.WHITE_STAINED_TILED_GLASS_PANE.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.YELLOW_STAINED_TILED_GLASS.get(), translucent);
        PlatformServices.REGISTRY.setBlockRenderType((Block)SMBBlocks.YELLOW_STAINED_TILED_GLASS_PANE.get(), translucent);
    }

    private static void registerModelPredicates() {
        PlatformServices.REGISTRY.registerModelPredicate((Item)SMBItems.LEAVES_BUCKET.get(), SMBDataComponentTypes.BUCKET_VOLUME.getPath());
        PlatformServices.REGISTRY.registerModelPredicate((Item)SMBItems.SPRUCE_LEAVES_BUCKET.get(), SMBDataComponentTypes.BUCKET_VOLUME.getPath());
        PlatformServices.REGISTRY.registerModelPredicate((Item)SMBItems.BIRCH_LEAVES_BUCKET.get(), SMBDataComponentTypes.BUCKET_VOLUME.getPath());
        PlatformServices.REGISTRY.registerModelPredicate((Item)SMBItems.AZALEA_LEAVES_BUCKET.get(), SMBDataComponentTypes.BUCKET_VOLUME.getPath());
        PlatformServices.REGISTRY.registerModelPredicate((Item)SMBItems.FLOWERING_AZALEA_LEAVES_BUCKET.get(), SMBDataComponentTypes.BUCKET_VOLUME.getPath());
    }
}

