/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.platform.registry;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.PushReaction;
import net.seface.somemoreblocks.item.LeavesBucketItem;
import net.seface.somemoreblocks.platform.registry.PlatformRegistryObject;

public interface PlatformRegistry {
    public PlatformRegistryObject<Block> registerBlock(String var1, Supplier<Block> var2, boolean var3);

    public PlatformRegistryObject<Item> registerItem(String var1, Supplier<Item> var2);

    public <T> PlatformRegistryObject<DataComponentType<T>> registerDataComponent(String var1, UnaryOperator<DataComponentType.Builder<T>> var2);

    default public void registerModelPredicate(Item item, String path) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"somemoreblocks", (String)path), (stack, world, entity, seed) -> stack.getItem() instanceof LeavesBucketItem ? (float)((Integer)stack.get(((LeavesBucketItem)stack.getItem()).getBucketVolumeComponentType())).intValue() / 100.0f : 0.01f);
    }

    public <F extends Feature<? extends FeatureConfiguration>> PlatformRegistryObject<F> registerFeature(String var1, Supplier<F> var2);

    public PlatformRegistryObject<CreativeModeTab> registerCreativeModeTab(String var1, CreativeModeTab.Row var2, int var3, UnaryOperator<CreativeModeTab.Builder> var4);

    public void setBlockRenderType(Block var1, RenderType var2);

    default public PlatformRegistryObject<Block> registerBlock(String path, Supplier<Block> supplier) {
        return this.registerBlock(path, supplier, true);
    }

    default public PlatformRegistryObject<Block> registerFlowerPotBlock(PlatformRegistryObject<Block> plant) {
        return this.registerFlowerPotBlock(plant, BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    default public PlatformRegistryObject<Block> registerFlowerPotBlock(PlatformRegistryObject<Block> plant, BlockBehaviour.Properties properties) {
        String path = "potted_" + plant.getPath();
        return this.registerBlock(path, () -> new FlowerPotBlock((Block)plant.get(), properties), false);
    }

    public GameRules.Key<GameRules.BooleanValue> registerBooleanGameRule(String var1, GameRules.Category var2, boolean var3);
}

