/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.seface.somemoreblocks.worldgen.ForgifiedBiomeModifier;
import net.seface.somemoreblocks.worldgen.PatchDunePlantsBiomeModifier;

public class SMBBiomeModifiers {
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> BIOME_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"somemoreblocks");
    public static Supplier<MapCodec<PatchDunePlantsBiomeModifier>> PATCH_DUNE_GRASS = SMBBiomeModifiers.registerBiomeModifier("patch_dune_grass", PatchDunePlantsBiomeModifier::new);

    private static <T extends BiomeModifier> Supplier<MapCodec<T>> registerBiomeModifier(String path, BiFunction<HolderSet<Biome>, Holder<PlacedFeature>, T> factory) {
        return BIOME_MODIFIERS.register(path, () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(instance -> ((ForgifiedBiomeModifier)instance).biomes(instance)), (App)PlacedFeature.CODEC.fieldOf("features").forGetter(instance -> ((ForgifiedBiomeModifier)instance).features(instance))).apply((Applicative)builder, factory)));
    }

    public static void init(IEventBus event) {
        BIOME_MODIFIERS.register(event);
    }
}

