/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.seface.somemoreblocks.registries.SMBGameRules;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VegetationBlock.class})
public abstract class VegetationBlockMixin
extends Block {
    public VegetationBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        Block block = state.getBlock();
        return SMBRegistries.SNOWY_PLANT_BLOCKS.getNext(block).isPresent() || SMBRegistries.SNOWY_PLANT_BLOCKS.getPrevious(block).isPresent() && !super.isRandomlyTicking(state) || SMBRegistries.SNOWY_PLANT_BLOCKS.getNext(block).isEmpty() || SMBRegistries.SNOWY_PLANT_BLOCKS.getPrevious(block).isEmpty() && super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getGameRules().getBoolean(SMBGameRules.RULE_SNOW_ACCUMULATE)) {
            this.SMB$turnIntoNormalVariation(state, (Level)level, pos);
            this.SMB$turnIntoSnowVariation(state, (Level)level, pos);
        }
    }

    @Unique
    private void SMB$turnIntoSnowVariation(BlockState state, Level level, BlockPos pos) {
        boolean isDoublePlant = state.hasProperty((Property)DoublePlantBlock.HALF);
        boolean isSnowing = ((Biome)level.getBiome(pos).value()).coldEnoughToSnow(pos, level.getSeaLevel()) && level.isRaining() && level.canSeeSky(pos);
        Optional<Block> snowyVariation = SMBRegistries.SNOWY_PLANT_BLOCKS.getNext(state.getBlock());
        if (snowyVariation.isEmpty()) {
            return;
        }
        if (!isSnowing || level.getBrightness(LightLayer.BLOCK, pos) > 11) {
            return;
        }
        if (isDoublePlant) {
            if (((DoubleBlockHalf)state.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                return;
            }
            level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 260);
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)snowyVariation.get().withPropertiesOf(state), (BlockPos)pos, (int)2);
            return;
        }
        level.setBlock(pos, snowyVariation.get().withPropertiesOf(state), 3);
    }

    @Unique
    private void SMB$turnIntoNormalVariation(BlockState state, Level level, BlockPos pos) {
        boolean isDoublePlant = state.hasProperty((Property)DoublePlantBlock.HALF);
        if (level.getBrightness(LightLayer.BLOCK, pos) > 11) {
            Optional<Block> normalVariation = SMBRegistries.SNOWY_PLANT_BLOCKS.getPrevious(state.getBlock());
            if (normalVariation.isEmpty()) {
                return;
            }
            if (isDoublePlant) {
                if (((DoubleBlockHalf)state.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                    return;
                }
                level.setBlock(pos.above(), Blocks.AIR.defaultBlockState(), 260);
                DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)normalVariation.get().withPropertiesOf(state), (BlockPos)pos, (int)3);
                return;
            }
            level.setBlock(pos, normalVariation.get().withPropertiesOf(state), 3);
        }
    }
}

