/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.worldgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.tags.SMBBlockTags;
import net.seface.somemoreblocks.worldgen.feature.configurations.SimpleLeafLitterBlockConfiguration;

public class LeafLitterFeature
extends Feature<SimpleLeafLitterBlockConfiguration> {
    private static final int CHUNK_SIZE = 16;

    public LeafLitterFeature(Codec<SimpleLeafLitterBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleLeafLitterBlockConfiguration> ctx) {
        BlockPos pos = ctx.origin();
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        BlockState leafLitter = ((SimpleLeafLitterBlockConfiguration)ctx.config()).toPlace().getState(random, pos);
        float placeChance = ((SimpleLeafLitterBlockConfiguration)ctx.config()).chance();
        int xzSpread = ((SimpleLeafLitterBlockConfiguration)ctx.config()).xzSpread();
        List<ResourceKey<Block>> parents = ((SimpleLeafLitterBlockConfiguration)ctx.config()).parents();
        for (int xIndex = 0; xIndex < 16; ++xIndex) {
            for (int zIndex = 0; zIndex < 16; ++zIndex) {
                BlockState state2;
                float chance;
                int x = pos.getX() + xIndex;
                int z = pos.getZ() + zIndex;
                mPos.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!parents.contains(BuiltInRegistries.BLOCK.getResourceKey((Object)level.getBlockState((BlockPos)mPos).getBlock()).get())) continue;
                Vec3i v3Pos = new Vec3i(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                Vec3i offset = new Vec3i(random.nextInt(xzSpread) - random.nextInt(xzSpread), 0, random.nextInt(xzSpread) - random.nextInt(xzSpread));
                mPos.setWithOffset(v3Pos, offset);
                BlockState stateBelow = level.getBlockState(mPos.below());
                if (!Block.isFaceFull((VoxelShape)stateBelow.getCollisionShape((BlockGetter)level, mPos.below()), (Direction)Direction.UP) && !stateBelow.is(SMBBlockTags.LEAF_LITTERS_PLACEABLE) || !((chance = random.nextFloat() * 100.0f) <= placeChance) || !(state2 = level.getBlockState((BlockPos)mPos)).isAir() && !state2.is(SMBBlockTags.LEAF_LITTER_REPLACEABLE)) continue;
                level.setBlock((BlockPos)mPos, leafLitter, 2);
            }
        }
        return true;
    }
}

