/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.registries.SMBBlocks;
import net.seface.somemoreblocks.tags.SMBBlockTags;

public class CloverBlock
extends BushBlock {
    public static final MapCodec<CloverBlock> CODEC = CloverBlock.simpleCodec(CloverBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AMOUNT = BlockStateProperties.FLOWER_AMOUNT;
    private static final BiFunction<Direction, Integer, VoxelShape> SHAPE_BY_PROPERTIES = Util.memoize((direction, amount) -> {
        VoxelShape[] shapes = new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)3.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)3.0, (double)16.0)};
        VoxelShape shape = Shapes.empty();
        for (int i = 0; i < amount; ++i) {
            int $$5 = Math.floorMod(i - direction.get2DDataValue(), 4);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)shapes[$$5]);
        }
        return shape.singleEncompassing();
    });
    public static final int MIN_FLOWERS = 1;
    public static final int MAX_FLOWERS = 4;

    public CloverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING, AMOUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter block, BlockPos pos, CollisionContext ctx) {
        return SHAPE_BY_PROPERTIES.apply((Direction)state.getValue(FACING), (Integer)state.getValue((Property)AMOUNT));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext ctx) {
        return !ctx.isSecondaryUseActive() && ctx.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)AMOUNT) < 4 ? true : super.canBeReplaced(state, ctx);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        return state.is((Block)this) ? (BlockState)state.setValue((Property)AMOUNT, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.getValue((Property)AMOUNT) + 1))) : (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.is((Block)SMBBlocks.NETHER_CLOVER.get())) {
            BlockState blockBelow = level.getBlockState(pos.below());
            return blockBelow.is(SMBBlockTags.NETHER_CLOVER_PLACEABLE) && !level.getBlockState(pos.above()).liquid();
        }
        return super.canSurvive(state, level, pos);
    }
}

