/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Unique
    private Level SMB$level = null;

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnMixin(UseOnContext ctx, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        ItemStack heldItem = ctx.getItemInHand();
        BlockPos clickedPos = ctx.getClickedPos();
        BlockState state = level.getBlockState(clickedPos);
        if (this.SMB$level == null) {
            this.SMB$level = level;
        }
        Block block = state.getBlock();
        Optional<Block> carvedWoodOrLog = SMBRegistries.CARVED_BLOCKS.getNext(block);
        Optional<Block> weatheringOff = SMBRegistries.WEATHERING_COPPER_BLOCKS.getPrevious(block);
        Optional<Block> waxableOff = SMBRegistries.WAXED_COPPER_BLOCKS.getPrevious(block);
        Optional<Object> result = Optional.empty();
        Optional<Object> soundEvent = Optional.empty();
        if (carvedWoodOrLog.isPresent()) {
            result = Optional.of(carvedWoodOrLog.get().withPropertiesOf(state));
            soundEvent = Optional.of(SoundEvents.AXE_STRIP);
        } else if (weatheringOff.isPresent()) {
            result = Optional.of(weatheringOff.get().withPropertiesOf(state));
            soundEvent = Optional.of(SoundEvents.AXE_SCRAPE);
            level.levelEvent(player, 3005, clickedPos, 0);
        } else if (waxableOff.isPresent()) {
            result = Optional.of(waxableOff.get().withPropertiesOf(state));
            soundEvent = Optional.of(SoundEvents.AXE_WAX_OFF);
            level.levelEvent(player, 3004, clickedPos, 0);
        }
        if (result.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, clickedPos, heldItem);
            }
            level.setBlock(clickedPos, (BlockState)result.get(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, clickedPos, GameEvent.Context.of((Entity)player, (BlockState)((BlockState)result.get())));
            level.playSound(player, clickedPos, (SoundEvent)soundEvent.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player != null) {
                heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)ctx.getHand()));
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

