/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.block.properties.QuadDirection;
import net.seface.somemoreblocks.registries.SMBBlockStateProperties;
import net.seface.somemoreblocks.registries.SMBBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigLilyPadBlock
extends WaterlilyBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<QuadDirection> POSITION = SMBBlockStateProperties.POSITION;

    public BigLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(POSITION, (Comparable)((Object)QuadDirection.BOTTOM_LEFT))).m_61124_(FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter block, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> property) {
        property.m_61104_(new Property[]{POSITION, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Direction facing = context.m_8125_();
        BlockPos topLeftPos = pos.m_121945_(facing);
        BlockPos topRightPos = pos.m_121945_(facing.m_122427_()).m_121945_(facing);
        BlockPos bottomRightPos = pos.m_121945_(facing.m_122427_());
        boolean isPlaceable = level.m_8055_(pos).m_60629_(context) && level.m_8055_(topLeftPos).m_60629_(context) && level.m_8055_(topRightPos).m_60629_(context) && level.m_8055_(bottomRightPos).m_60629_(context);
        boolean isOnFluidOrIce = !(!level.m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50126_) || !level.m_6425_(topLeftPos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !level.m_8055_(topLeftPos.m_7495_()).m_60713_(Blocks.f_50126_) || !level.m_6425_(topRightPos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !level.m_8055_(topRightPos.m_7495_()).m_60713_(Blocks.f_50126_) || !level.m_6425_(bottomRightPos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_) && !level.m_8055_(bottomRightPos.m_7495_()).m_60713_(Blocks.f_50126_));
        return isPlaceable && isOnFluidOrIce ? super.m_5573_(context) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack item) {
        Direction facing = player != null ? player.m_6350_() : Direction.m_235672_((RandomSource)RandomSource.m_216327_());
        BlockPos topLeftPos = pos.m_121945_(facing);
        BlockPos topRightPos = pos.m_121945_(facing.m_122427_()).m_121945_(facing);
        BlockPos bottomRightPos = pos.m_121945_(facing.m_122427_());
        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)facing), 3);
        level.m_7731_(bottomRightPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.BOTTOM_RIGHT), 3);
        level.m_7731_(topRightPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.TOP_RIGHT), 3);
        level.m_7731_(topLeftPos, BigLilyPadBlock.createBlockStateFor(state, facing, QuadDirection.TOP_LEFT), 3);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos neighborBlockPos = this.getRelativeBlockPos(state, pos);
        QuadDirection expectedPosition = this.getExpectedNeighborPosition(state);
        BlockState neighborState = level.m_8055_(neighborBlockPos);
        if (state.m_61143_(POSITION) != QuadDirection.BOTTOM_LEFT) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(POSITION) == expectedPosition && super.m_7898_(state, level, pos);
        }
        return super.m_7898_(state, level, pos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bool) {
        BlockPos bottomLeftPos;
        Direction facing = (Direction)state.m_61143_(FACING);
        QuadDirection position = (QuadDirection)((Object)state.m_61143_(POSITION));
        if (position == QuadDirection.BOTTOM_RIGHT && level.m_8055_(bottomLeftPos = pos.m_121945_(facing.m_122428_())).m_60713_((Block)this)) {
            level.m_46961_(bottomLeftPos, true);
            return;
        }
        super.m_6810_(state, level, pos, newState, bool);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (player.m_7500_()) {
            this.preventDropFromBottomLeftPart(level, pos, state, player);
        }
    }

    protected void preventDropFromBottomLeftPart(Level level, BlockPos pos, BlockState state, Player player) {
        QuadDirection position = (QuadDirection)((Object)state.m_61143_(POSITION));
        if (position == QuadDirection.BOTTOM_LEFT) {
            return;
        }
        BlockPos bottomLeftPos = this.getRelativeBottomLeftBlockPos(state, pos);
        BlockState bottomLeft = level.m_8055_(bottomLeftPos);
        level.m_7731_(bottomLeftPos, Blocks.f_50069_.m_49966_(), 35);
        if (bottomLeft.m_60713_((Block)this) && bottomLeft.m_61143_(POSITION) == QuadDirection.BOTTOM_LEFT) {
            BlockState newState = bottomLeft.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            level.m_7731_(bottomLeftPos, newState, 35);
            level.m_5898_(player, 2001, bottomLeftPos, Block.m_49956_((BlockState)bottomLeft));
        }
    }

    public static void placeAt(LevelAccessor level, Direction facing, BlockPos pos, int i) {
        BlockState bigLilyPad = ((Block)SMBBlocks.BIG_LILY_PAD.get()).m_49966_();
        BlockPos topLeftPos = pos.m_121945_(facing);
        BlockPos topRightPos = pos.m_121945_(facing.m_122427_()).m_121945_(facing);
        BlockPos bottomRightPos = pos.m_121945_(facing.m_122427_());
        level.m_7731_(pos, (BlockState)bigLilyPad.m_61124_(FACING, (Comparable)facing), i);
        level.m_7731_(bottomRightPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.BOTTOM_RIGHT), i);
        level.m_7731_(topRightPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.TOP_RIGHT), i);
        level.m_7731_(topLeftPos, BigLilyPadBlock.createBlockStateFor(bigLilyPad, facing, QuadDirection.TOP_LEFT), i);
    }

    private static BlockState createBlockStateFor(BlockState state, Direction facing, QuadDirection position) {
        return (BlockState)((BlockState)state.m_61124_(FACING, (Comparable)facing)).m_61124_(POSITION, (Comparable)((Object)position));
    }

    private BlockPos getRelativeBlockPos(BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACING);
        QuadDirection position = (QuadDirection)((Object)state.m_61143_(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.BOTTOM_LEFT -> pos.m_121945_(facing.m_122427_());
            case QuadDirection.TOP_LEFT -> pos.m_121945_(facing.m_122424_());
            case QuadDirection.TOP_RIGHT -> pos.m_121945_(facing.m_122428_());
            case QuadDirection.BOTTOM_RIGHT -> pos.m_121945_(facing);
        };
    }

    private BlockPos getRelativeBottomLeftBlockPos(BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACING);
        QuadDirection position = (QuadDirection)((Object)state.m_61143_(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.TOP_LEFT -> pos.m_121945_(facing.m_122424_());
            case QuadDirection.TOP_RIGHT -> pos.m_121945_(facing.m_122428_()).m_121945_(facing.m_122424_());
            case QuadDirection.BOTTOM_LEFT -> pos;
            case QuadDirection.BOTTOM_RIGHT -> pos.m_121945_(facing.m_122428_());
        };
    }

    private QuadDirection getExpectedNeighborPosition(BlockState state) {
        QuadDirection position = (QuadDirection)((Object)state.m_61143_(POSITION));
        return switch (position) {
            default -> throw new IncompatibleClassChangeError();
            case QuadDirection.BOTTOM_LEFT -> QuadDirection.BOTTOM_RIGHT;
            case QuadDirection.TOP_LEFT -> QuadDirection.BOTTOM_LEFT;
            case QuadDirection.TOP_RIGHT -> QuadDirection.TOP_LEFT;
            case QuadDirection.BOTTOM_RIGHT -> QuadDirection.TOP_RIGHT;
        };
    }
}

