/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.block.LeafLitterBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeavesBucketItem
extends SolidBucketItem {
    public static final String BUCKET_VOLUME = "bucket_volume";
    public static final int MAX_VOLUME = 16;
    public static final int MIN_VOLUME = 1;
    private static final int BAR_COLOR = 8418303;
    private final BlockState leafLitterState;

    public LeavesBucketItem(Block block, SoundEvent placeSound, Item.Properties properties) {
        super(block, placeSound, properties);
        ((LeafLitterBlock)block).setBucketItem((Item)this);
        this.leafLitterState = block.m_49966_();
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = ctx.m_43722_();
        int bucketVolume = LeavesBucketItem.getBucketVolume(stack);
        if (state.m_60734_().equals(this.m_40614_())) {
            if (bucketVolume == 16 && !player.m_7500_()) {
                return InteractionResult.FAIL;
            }
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            if (!level.m_5776_()) {
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            }
            if (!player.m_7500_() || bucketVolume < 16) {
                LeavesBucketItem.setBucketVolume(stack, bucketVolume + 1);
            }
            return InteractionResult.SUCCESS;
        }
        if (bucketVolume > 0) {
            BlockPlaceContext placeContext = new BlockPlaceContext(ctx);
            BlockPos relativePos = placeContext.m_8083_();
            BlockState relativeBlock = level.m_8055_(relativePos);
            if (!relativeBlock.m_247087_() || relativeBlock.m_60713_(this.leafLitterState.m_60734_())) {
                return InteractionResult.FAIL;
            }
            if (!this.m_40610_(placeContext, this.leafLitterState)) {
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, pos, stack);
            }
            this.m_7429_(placeContext, this.leafLitterState);
            SoundType soundType = state.m_60827_();
            level.m_5594_(player, pos, this.m_40587_(state), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            level.m_220407_(GameEvent.f_157797_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
            if (player.m_7500_()) {
                return InteractionResult.SUCCESS;
            }
            if (bucketVolume > 1) {
                LeavesBucketItem.setBucketVolume(stack, bucketVolume - 1);
                return InteractionResult.SUCCESS;
            }
            player.m_21008_(ctx.m_43724_(), BucketItem.m_40699_((ItemStack)stack, (Player)player));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_142522_(ItemStack stack) {
        return LeavesBucketItem.getBucketVolume(stack) < 16;
    }

    public int m_142158_(ItemStack stack) {
        return Math.min(13 * LeavesBucketItem.getBucketVolume(stack) / 16, 16);
    }

    public int m_142159_(ItemStack stack) {
        return 8418303;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltip, tooltipFlag);
        int bucketVolume = LeavesBucketItem.getBucketVolume(stack);
        tooltip.add(1, (Component)Component.m_237110_((String)"item.somemoreblocks.leaves_bucket.volume_description", (Object[])new Object[]{bucketVolume, 16}).m_130940_(ChatFormatting.GRAY));
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        LeavesBucketItem.setBucketVolume(stack, 16);
        return stack;
    }

    public static boolean hasBucketVolume(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(BUCKET_VOLUME);
    }

    public static void setBucketVolume(ItemStack stack, int value) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128405_(BUCKET_VOLUME, value);
    }

    public static int getBucketVolume(ItemStack stack) {
        if (LeavesBucketItem.hasBucketVolume(stack)) {
            return stack.m_41783_().m_128451_(BUCKET_VOLUME);
        }
        return 1;
    }
}

