/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Unique
    private Level SMB$level = null;

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnMixin(UseOnContext ctx, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack heldItem = ctx.m_43722_();
        BlockPos clickedPos = ctx.m_8083_();
        BlockState state = level.m_8055_(clickedPos);
        if (this.SMB$level == null) {
            this.SMB$level = level;
        }
        Block block = state.m_60734_();
        Optional<Block> carvedWoodOrLog = SMBRegistries.CARVED_BLOCKS.getNext(block);
        Optional<Block> weatheringOff = SMBRegistries.WEATHERING_COPPER_BLOCKS.getPrevious(block);
        Optional<Block> waxableOff = SMBRegistries.WAXED_COPPER_BLOCKS.getPrevious(block);
        Optional<Object> result = Optional.empty();
        Optional<Object> soundEvent = Optional.empty();
        if (carvedWoodOrLog.isPresent()) {
            result = Optional.of(carvedWoodOrLog.get().m_152465_(state));
            soundEvent = Optional.of(SoundEvents.f_11688_);
        } else if (weatheringOff.isPresent()) {
            result = Optional.of(weatheringOff.get().m_152465_(state));
            soundEvent = Optional.of(SoundEvents.f_144059_);
            level.m_5898_(player, 3005, clickedPos, 0);
        } else if (waxableOff.isPresent()) {
            result = Optional.of(waxableOff.get().m_152465_(state));
            soundEvent = Optional.of(SoundEvents.f_144060_);
            level.m_5898_(player, 3004, clickedPos, 0);
        }
        if (result.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, clickedPos, heldItem);
            }
            level.m_7731_(clickedPos, (BlockState)result.get(), 11);
            level.m_220407_(GameEvent.f_157792_, clickedPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)((BlockState)result.get())));
            level.m_5594_(player, clickedPos, (SoundEvent)soundEvent.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player != null) {
                heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
    }
}

