/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.worldgen.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.tags.SMBBlockTags;
import net.seface.somemoreblocks.worldgen.feature.configurations.SimpleLeafLitterBlockConfiguration;

public class LeafLitterFeature
extends Feature<SimpleLeafLitterBlockConfiguration> {
    private static final int CHUNK_SIZE = 16;

    public LeafLitterFeature(Codec<SimpleLeafLitterBlockConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleLeafLitterBlockConfiguration> ctx) {
        BlockPos pos = ctx.m_159777_();
        WorldGenLevel level = ctx.m_159774_();
        RandomSource random = ctx.m_225041_();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        BlockState leafLitter = ((SimpleLeafLitterBlockConfiguration)ctx.m_159778_()).toPlace().m_213972_(random, pos);
        float placeChance = ((SimpleLeafLitterBlockConfiguration)ctx.m_159778_()).chance();
        int xzSpread = ((SimpleLeafLitterBlockConfiguration)ctx.m_159778_()).xzSpread();
        List<ResourceKey<Block>> parents = ((SimpleLeafLitterBlockConfiguration)ctx.m_159778_()).parents();
        for (int xIndex = 0; xIndex < 16; ++xIndex) {
            for (int zIndex = 0; zIndex < 16; ++zIndex) {
                BlockState state2;
                float chance;
                int x = pos.m_123341_() + xIndex;
                int z = pos.m_123343_() + zIndex;
                mPos.m_122178_(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!parents.contains(BuiltInRegistries.f_256975_.m_7854_((Object)level.m_8055_((BlockPos)mPos).m_60734_()).get())) continue;
                Vec3i v3Pos = new Vec3i(x, level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                Vec3i offset = new Vec3i(random.m_188503_(xzSpread) - random.m_188503_(xzSpread), 0, random.m_188503_(xzSpread) - random.m_188503_(xzSpread));
                mPos.m_175306_(v3Pos, offset);
                BlockState stateBelow = level.m_8055_(mPos.m_7495_());
                if (!Block.m_49918_((VoxelShape)stateBelow.m_60812_((BlockGetter)level, mPos.m_7495_()), (Direction)Direction.UP) && !stateBelow.m_204336_(SMBBlockTags.LEAF_LITTERS_PLACEABLE) || !((chance = random.m_188501_() * 100.0f) <= placeChance) || !(state2 = level.m_8055_((BlockPos)mPos)).m_60795_() && !state2.m_204336_(SMBBlockTags.LEAF_LITTER_REPLACEABLE)) continue;
                level.m_7731_((BlockPos)mPos, leafLitter, 2);
            }
        }
        return true;
    }
}

