/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.seface.somemoreblocks.tags.SMBBlockTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WallMushroomColonyBlock
extends VegetationBlock {
    public static final MapCodec<WallMushroomColonyBlock> CODEC = WallMushroomColonyBlock.simpleCodec(WallMushroomColonyBlock::new);
    protected static final Map<Direction, VoxelShape> SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), (Object)Direction.WEST, (Object)Block.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0)));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public WallMushroomColonyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<WallMushroomColonyBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter block, BlockPos pos, CollisionContext collisionCtx) {
        return SHAPE.get(state.getValue(FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> property) {
        property.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] direction;
        BlockState state = this.defaultBlockState();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction[] savedDirection = direction = ctx.getNearestLookingDirections();
        int directionLen = direction.length;
        for (int i = 0; i < directionLen; ++i) {
            Direction $$6;
            Direction direction1 = savedDirection[i];
            if (!direction1.getAxis().isHorizontal() || !(state = (BlockState)state.setValue(FACING, (Comparable)($$6 = direction1.getOpposite()))).canSurvive((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue(FACING);
        BlockPos relativePos = pos.relative(direction.getOpposite());
        BlockState block = level.getBlockState(relativePos);
        return block.is(SMBBlockTags.MUSHROOM_COLONY_PLACEABLE);
    }
}

