/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.worldgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.seface.somemoreblocks.block.BigLilyPadBlock;
import net.seface.somemoreblocks.tags.SMBBlockTags;

public class BigLilyPadFeature
extends Feature<NoneFeatureConfiguration> {
    public BigLilyPadFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos pos = ctx.origin();
        WorldGenLevel level = ctx.level();
        RandomSource random = ctx.random();
        Direction facing = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos bottomRightPos = pos.relative(facing.getClockWise());
        BlockPos topLeftPos = pos.relative(facing);
        BlockPos topRightPos = pos.relative(facing.getClockWise()).relative(facing);
        if (!(this.isValidPlacement(level, pos) && this.isValidPlacement(level, bottomRightPos) && this.isValidPlacement(level, topLeftPos) && this.isValidPlacement(level, topRightPos))) {
            return false;
        }
        BigLilyPadBlock.placeAt((LevelAccessor)level, facing, pos, 3);
        return true;
    }

    private boolean isValidPlacement(WorldGenLevel level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        return !(!level.getBlockState(pos).canBeReplaced() && !level.getBlockState(pos).isAir() && !level.getBlockState(pos).is(SMBBlockTags.BIG_LILY_PAD_REPLACEABLE) || !level.getFluidState(belowPos).is((Fluid)Fluids.WATER) && !level.getBlockState(belowPos).is(Blocks.ICE));
    }
}

