/*
 * Decompiled with CFR 0.152.
 */
package net.seface.somemoreblocks.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.seface.somemoreblocks.platform.PlatformServices;
import net.seface.somemoreblocks.registries.SMBRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Unique
    private Level SMB$level = null;

    @Inject(method={"getStripped"}, at={@At(value="HEAD")}, cancellable=true)
    private void getStrippedMixin(BlockState state, CallbackInfoReturnable<Optional<BlockState>> cir) {
        if (PlatformServices.HELPER.is(PlatformServices.Platforms.NEOFORGE)) {
            return;
        }
        SMBRegistries.CARVED_BLOCKS.getNext(state.m_60734_()).ifPresent(block -> cir.setReturnValue(Optional.of(block.m_152465_(state))));
    }

    @Inject(method={"useOn"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOnMixin(UseOnContext ctx, CallbackInfoReturnable<InteractionResult> cir) {
        if (PlatformServices.HELPER.is(PlatformServices.Platforms.NEOFORGE)) {
            return;
        }
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (this.SMB$level == null) {
            this.SMB$level = level;
        }
        Optional<Block> weatheringOff = SMBRegistries.WEATHERING_COPPER_BLOCKS.getPrevious(state.m_60734_());
        Optional<Block> waxableOff = SMBRegistries.WAXED_COPPER_BLOCKS.getPrevious(state.m_60734_());
        if (weatheringOff.isPresent()) {
            this.SMB$evaluateNewBlockState(ctx, level, weatheringOff.get().m_49966_(), SoundEvents.f_144059_, 3005);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
        if (waxableOff.isPresent()) {
            this.SMB$evaluateNewBlockState(ctx, level, waxableOff.get().m_49966_(), SoundEvents.f_144060_, 3004);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    @Unique
    private void SMB$evaluateNewBlockState(UseOnContext ctx, Level level, BlockState newState, SoundEvent soundEvent, int levelEvent) {
        Player player = ctx.m_43723_();
        BlockPos pos = ctx.m_8083_();
        level.m_7731_(pos, newState, 11);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
        level.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_5898_(player, levelEvent, pos, 0);
        if (player != null) {
            ctx.m_43722_().m_41622_(1, (LivingEntity)player, _player -> _player.m_21190_(ctx.m_43724_()));
        }
    }
}

